<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */
class d3_usermanager_jobs extends oxAdminDetails
{
    /** @var d3usermanagerlist */
    protected $_aJobList;
    protected $_sHelpLinkMLAdd;

    /**
     * @return string
     */
    public function render()
    {
        parent::render();

        $soxId = $this->getEditObjectId();
        $this->addTplParam("oxid", $soxId);

        if ($soxId != "-1" && isset($soxId)) {
            // load object
            $oItem = oxNew("oxuser");
            $oItem->load($soxId);
            $this->addTplParam("edit", $oItem);
        }

        $sJobFolder = oxRegistry::getSession()->getVariable('d3UserManagerFolderSelect');
        $this->addTplParam("jobfolder", $sJobFolder);
        $this->_aJobList = $this->_d3GetManuallyManagerJobs($sJobFolder);

        return "d3_usermanager_jobs.tpl";
    }

    public function changeFolder()
    {
        oxRegistry::getSession()->setVariable(
            'd3UserManagerFolderSelect',
            oxRegistry::getConfig()->getRequestParameter('jobfolder')
        );
    }

    /**
     * @return d3usermanagerlist
     */
    public function d3GetManagerJobs()
    {
        /** @var d3usermanagerlist $oManagerList */
        $oManagerList = oxNew('d3usermanagerlist');
        $oManagerList->getList();

        return $oManagerList;
    }

    /**
     * @param $sFolderId
     * @return d3usermanagerlist
     */
    protected function _d3GetManuallyManagerJobs($sFolderId)
    {
        /** @var $oManagerList d3usermanagerlist */
        $oManagerList = oxNew('d3usermanagerlist');
        return $oManagerList->d3GetManuallyManagerJobsByFolder($sFolderId);
    }

    /**
     * @return array
     */
    public function d3GetJobList()
    {
        return $this->_aJobList->getArray();
    }

    public function d3execusermanager()
    {
        /** @var d3usermanager $oManager */
        $oManager = oxNew('d3usermanager');
        $oManager->load(oxRegistry::getConfig()->getRequestParameter('usermanagerid'));
        /** @var d3usermanager_execute $oManagerExec */
        $oManagerExec = oxNew('d3usermanager_execute', $oManager);
        $oManagerExec->exec4user(oxRegistry::getConfig()->getRequestParameter('oxid'));
        $oManagerExec->finishJobExecution();
    }

    public function d3ExecChangedUserManager()
    {
        /** @var d3usermanager $oManager */
        $oManager = oxNew('d3usermanager');
        $oManager->load(oxRegistry::getConfig()->getRequestParameter('usermanagerid'));
        $oManager->setEditedValues(oxRegistry::getConfig()->getRequestParameter('aContent'));
        /** @var d3usermanager_execute $oManagerExec */
        $oManagerExec = oxNew('d3usermanager_execute', $oManager);
        $oManagerExec->exec4user(oxRegistry::getConfig()->getRequestParameter('oxid'));
        $oManagerExec->finishJobExecution();
    }

    public function d3resetUserManagerAssignment()
    {
        /** @var d3usermanager $oManager */
        $oManager = oxNew('d3usermanager');
        /** @var d3usermanager_toUserAssignment $oAssignment */
        $oAssignment = oxNew('d3usermanager_toUserAssignment', $oManager);
        $oAssignment->resetAssignment(
            oxRegistry::getConfig()->getRequestParameter('usermanagerid'),
            oxRegistry::getConfig()->getRequestParameter('oxid')
        );
    }

    /**
     * @return mixed
     */
    public function getFolderList()
    {
        /** @var d3usermanager $oManager */
        $oManager = oxNew('d3usermanager');
        return $oManager->d3getSelectableFolderList();
    }

    public function execChangedContents()
    {
        $sItemId = oxRegistry::getConfig()->getRequestParameter('oxid');
        /** @var $oManager d3usermanager */
        $oManager = oxNew('d3usermanager');
        $oManager->load(oxRegistry::getConfig()->getRequestParameter('usermanagerid'));
        $this->addTplParam('aMailContent', $oManager->getEditableContent($sItemId));
        $this->addTplParam('sAction', __FUNCTION__);
        $this->addTplParam('oUserManager', $oManager);
    }

    /**
     * @return array
     */
    public function getUserMessages()
    {
        return array();
    }

    /**
     * @return string
     */
    public function getBGLogoUrl()
    {
        $aParams = array(
            'cl'  => $this->getClassName(),
            'fnc' => 'background_logo'
        );
        $sURL    = oxRegistry::get('d3utils')->getAdminClassUrl($aParams);

        return $sURL;
    }

    public function background_logo()
    {
        d3_cfg_mod::background_logo();
    }

    /**
     * @return string
     */
    public function getHelpURL()
    {
        $sUrl = $this->d3GetSet()->getHelpURL();
        /** @var $oFS d3filesystem */
        $oFS = oxNew('d3filesystem');

        if ($this->_sHelpLinkMLAdd) {
            $sUrl .= $oFS->unprefixedslashit(oxRegistry::getLang()->TranslateString($this->_sHelpLinkMLAdd));
        }

        $aFileName = $oFS->splitFilename($sUrl);

        // has no extension
        if (false == $aFileName['ext']) {
            $sUrl = $oFS->trailingslashit($sUrl);
        }

        return $sUrl;
    }

    /**
     * @return d3_cfg_mod
     */
    public function d3GetSet()
    {
        return d3_cfg_mod::get('d3usermanager');
    }
}
