<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */
class d3_cfg_usermanageritem_requ extends d3_cfg_usermanageritem_settings
{
    protected $_sThisTemplate = "d3_cfg_usermanageritem_requ.tpl";
    protected $_aTransStatus = array('OK', 'ERROR', 'NOT_OK');
    protected $_sMenuSubItemTitle = 'd3mxusermanager_items';

    /**
     * @throws oxSystemComponentException
     */
    public function save()
    {
        parent::save();

        $aMissingRequiredValues = array();
        /** @var d3usermanager_requirement_abstract $oRequirement */
        foreach ($this->getRequirementList() as $sId => $oRequirement) {
            if ($this->getProfile()->getValue($oRequirement->sRequActiveSwitch) && false == $oRequirement->hasRequiredValues()) {
                $aMissingRequiredValues[] = $sId;
            }
        };

        if (count($aMissingRequiredValues)) {
            $this->addTplParam('missingRequValuesActions', $aMissingRequiredValues);
        }
    }

    /**
     * @return oxpaymentlist
     * @throws oxSystemComponentException
     */
    public function getPaymentList()
    {
        /** @var oxpaymentlist $oPaymentList */
        $oPaymentList = oxNew('oxpaymentlist');
        return $this->_getObjectList($oPaymentList);
    }

    /**
     * @return oxdeliverysetlist
     * @throws oxSystemComponentException
     */
    public function getDeliveryList()
    {
        /** @var oxdeliverylist $oDeliveryList */
        $oDeliveryList = oxNew('oxdeliverysetlist');
        return $this->_getObjectList($oDeliveryList);
    }

    /**
     * @return oxcountrylist
     * @throws oxSystemComponentException
     */
    public function getCountryList()
    {
        /** @var oxcountrylist $oCountryList */
        $oCountryList = oxNew('oxcountrylist');
        return $this->_getObjectList($oCountryList);
    }

    /**
     * @return d3UsermanagerList
     * @throws oxSystemComponentException
     */
    public function getJobList()
    {
        $sCurrentId = $this->getViewDataElement('edit')->getId();
        /** @var $oManagerList d3UsermanagerList */
        $oManagerList = oxNew('d3usermanagerlist');
        $oManagerList->setCustomSorting('oxsort ASC');
        $oManagerList->getList();
        $oManagerList->offsetUnset($sCurrentId);
        return $oManagerList;
    }

    /**
     * @return array
     */
    public function getLanguageList()
    {
        $aLanguageList = oxRegistry::getLang()->getLanguageArray();
        return $aLanguageList;
    }

    /**
     * @return array
     */
    public function getTransStatusList()
    {
        return $this->_aTransStatus;
    }

    /**
     * Sets default values for empty article (currently does nothing), returns
     * array with parameters.
     *
     * @param array $aParams Parameters, to set default values
     *
     * @return array
     */
    public function addDefaultValues($aParams)
    {
        return $aParams;
    }

    /**
     * @return array
     * @throws oxSystemComponentException
     */
    public function getGroupedRequirementList()
    {
        /** @var d3usermanager $oManager */
        $oManager = $this->getProfile();
        /** @var d3usermanager_requirementgrouplist $oRequList */
        $oRequList = oxNew('d3usermanager_requirementgrouplist', $oManager);
        $oRequList->setGroups($oManager->getConfiguration()->getGroupedRequirementIdList());

        return $oRequList->getGroupList();
    }

    /**
     * @return array
     * @throws oxSystemComponentException
     */
    public function getRequirementList()
    {
        /** @var d3usermanager $oManager */
        $oManager = $this->getProfile();
        /** @var d3usermanager_requirementlist $oRequList */
        $oRequList = oxNew('d3usermanager_requirementlist', $oManager);
        $oRequList->setRequirements($oManager->getConfiguration()->getRequirementIdList());

        return $oRequList->getRequirementList();
    }
}
