<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Ray Ehrhardt <re@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

/**
 * Smarty function
 * -------------------------------------------------------------
 * Purpose: Output core class object
 * add [{d3getobject type="oxarticle"ident="abc123" field="oxtitle" assign="oProduct"}] where you want to display content
 * -------------------------------------------------------------
 *
 * @param $params
 * @param $smarty Smarty
 *
 * @return oxbase
 * @throws Exception
 */
function smarty_function_d3getobject( $params, &$smarty )
{
    $sIdent  = isset( $params['ident'] ) ? $params['ident'] : '';
    $sType   = isset( $params['type'] ) ? $params['type'] : '';
    $sField  = isset( $params['field'] ) ? $params['field'] : '';
    $sAssign = isset( $params['assign'] ) ? $params['assign'] : '';

    $mRet = null;
    if(false == $sType) {
        throw new Exception('You need to define an object type! Use type="myClass".');
    }

    $oObject = oxNew($sType);

    if(empty($sIdent) == false && $oObject->Load($sIdent) == false) {
        throw new Exception("couldn't load ident: $sIdent");
    }

    if($sField) {
        $mRet = $oObject->getFieldData($sField);
    } else {
        $mRet = $oObject;
    }

    if($sAssign) {
        $smarty->assign($sAssign, $mRet);
    } else {
        return $mRet;
    }

    return null;
}
