<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development, Thomas Dartsch
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_ModuleControllerMapProvider_modcfg extends d3_ModuleControllerMapProvider_modcfg_parent
{
    private $controllerMap = [
        'd3tplblocks'               => \D3\ModCfg\Application\Controller\Admin\TPLBlocks\d3tplblocks::class,
        'd3tplblocks_list'          => \D3\ModCfg\Application\Controller\Admin\TPLBlocks\d3tplblocks_list::class,
        'd3tplblocks_main'          => \D3\ModCfg\Application\Controller\Admin\TPLBlocks\d3tplblocks_main::class,
        'd3tplblocks_extend'        => \D3\ModCfg\Application\Controller\Admin\TPLBlocks\d3tplblocks_extend::class,

        'd3modext'                  => \D3\ModCfg\Application\Controller\Admin\Configuration\d3modext::class,
        'd3modext_list'             => \D3\ModCfg\Application\Controller\Admin\Configuration\d3modext_list::class,
        'd3modext_status'           => \D3\ModCfg\Application\Controller\Admin\Configuration\d3modext_status::class,
        'd3modext_new'              => \D3\ModCfg\Application\Controller\Admin\Configuration\d3modext_new::class,
        'd3_mod_update'             => \D3\ModCfg\Application\Controller\Admin\Install\d3_mod_update::class,
        'd3modlib_support'          => \D3\ModCfg\Application\Controller\Admin\Configuration\d3modlib_support::class,

        'd3modlib'                  => \D3\ModCfg\Application\Controller\Admin\Configuration\d3modlib::class,
        'd3modlib_list'             => \D3\ModCfg\Application\Controller\Admin\Configuration\d3modlib_list::class,
        'd3modlib_status'           => \D3\ModCfg\Application\Controller\Admin\Configuration\d3modlib_status::class,

        'd3sysitems'                => \D3\ModCfg\Application\Controller\Admin\Maintenance\d3sysitems::class,
        'd3sysitems_list'           => \D3\ModCfg\Application\Controller\Admin\Maintenance\d3sysitems_list::class,
        'd3cfgitems'                => \D3\ModCfg\Application\Controller\Admin\Maintenance\d3cfgitems::class,
        'd3moditems'                => \D3\ModCfg\Application\Controller\Admin\Maintenance\d3moditems::class,
        'd3maintenance'             => \D3\ModCfg\Application\Controller\Admin\Maintenance\d3maintenance::class,

        'd3_cfg_log'                => \D3\ModCfg\Application\Controller\Admin\Log\d3_cfg_log::class,
        'd3_cfg_log_list'           => \D3\ModCfg\Application\Controller\Admin\Log\d3_cfg_log_list::class,
        'd3_cfg_log_main'           => \D3\ModCfg\Application\Controller\Admin\Log\d3_cfg_log_main::class,
        'd3_cfg_log_cleanup'        => \D3\ModCfg\Application\Controller\Admin\Log\d3_cfg_log_cleanup::class,

        'd3cleartmp_frame'          => \D3\ModCfg\Application\Controller\Admin\Maintenance\d3cleartmp_frame::class,
        'd3cleartmp_list'           => \D3\ModCfg\Application\Controller\Admin\Maintenance\d3cleartmp_list::class,
        'd3cleartmp'                => \D3\ModCfg\Application\Controller\Admin\Maintenance\d3cleartmp::class,
        'd3shopmaintenance'         => \D3\ModCfg\Application\Controller\Admin\Maintenance\d3shopmaintenance::class,

        'd3mod_activation'          => \D3\ModCfg\Application\Controller\Admin\Install\d3mod_activation::class,
        'd3_mod_install'            => \D3\ModCfg\Application\Controller\Admin\Install\d3_mod_install::class,
    ];

    /**
     * @inheritdoc
     */
    public function getControllerMap()
    {
        return array_merge(parent::getControllerMap(), $this->controllerMap);
    }
}