<?php
/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

use OxidEsales\Eshop\Core as OxidCore;
use OxidEsales\Eshop\Application\Controller\Admin as OxidAdminController;
use OxidEsales\Eshop\Application\Model as OxidModel;
use D3\ModCfg\Application\Controller\Admin as ModuleAdminController;
use D3\ModCfg\Application\Controller\Admin\Configuration as ModuleAdminCnfController;
use D3\ModCfg\Application\Controller\Admin\Install as ModuleAdminInstallController;
use D3\ModCfg\Application\Controller\Admin\Log as ModuleAdminLogController;
use D3\ModCfg\Application\Controller\Admin\Maintenance as ModuleAdminMntController;
use D3\ModCfg\Application\Controller\Admin\TPLBlocks as ModuleAdminTplController;
use D3\ModCfg\Application\Model as ModuleModel;
use D3\ModCfg\Application\Model\Configuration as ModuleCnfModel;
use D3\ModCfg\Application\Model\Encoding as ModuleEncModel;
use D3\ModCfg\Application\Model\Exception as ModuleExcModel;
use D3\ModCfg\Application\Model\Filegenerator as ModuleFlgModel;
use D3\ModCfg\Application\Model\Install as ModuleInsModel;
use D3\ModCfg\Application\Model\Installcheck as ModuleIncModel;
use D3\ModCfg\Application\Model\Installwizzard as ModuleInwModel;
use D3\ModCfg\Application\Model\Log as ModuleLogModel;
use D3\ModCfg\Application\Model\Maintenance as ModuleMntModel;
use D3\ModCfg\Application\Model\Parametercontainer as ModulePcnModel;
use D3\ModCfg\Application\Model\Shopcompatibility as ModuleCmpModel;
use D3\ModCfg\Application\Model\Transactionlog as ModuleTalModel;
use D3\ModCfg\setup as ModuleSetup;

/**
 * Metadata version
 */
$sMetadataVersion = '1.2';

$sModuleId = 'd3modcfg_lib';

$aModule = [
    'id'          => $sModuleId,
    'title'       => '<img src="../modules/d3/modcfg/public/d3logo.php?cl=' . $_REQUEST['cl'] .
        '" alt="D&sup3;" title="D&sup3; Data Development"> Modul-Connector',
    'description' => [
        'de' => 'enth&auml;lt:<ul><li>Modulkonfiguration</li>'.
                '<li>Installationsassistent</li>'.
                '<li>Logging</li>'.
                '<li>TMP leeren</li></ul>',
        'en' => 'contains:<ul><li>Module Configuration</li>'.
                '<li>installation wizzard</li>'.
                '<li>Logging</li>'.
                '<li>Clear TMP</li></ul>',
    ],
    'lang'        => 'de',
    'thumbnail'   => 'out/pictures/picture.png',
    'version'     => '5.0.0.0',
    'author'      => 'D&sup3; Data Development (Inh. Thomas Dartsch)',
    'email'       => 'support@shopmodule.com',
    'url'         => 'http://www.oxidmodule.com',
    'extend'      => [
        OxidCore\Module\ModuleInstaller::class  =>
            'd3/modcfg/Modules/Application/Model/d3_oxmoduleinstaller_activecheck',
        OxidAdminController\NavigationController::class  =>
            'd3/modcfg/Modules/Application/Controller/Admin/d3_navigation_modcfgupdate',
        OxidModel\Shop::class => 'd3/modcfg/Modules/Application/Model/d3_oxshop_modcfg',
        OxidCore\Routing\ModuleControllerMapProvider::class =>
            'd3/modcfg/Modules/Core/Routing/d3_ModuleControllerMapProvider_modcfg',
        OxidCore\ShopControl::class  => 'd3/modcfg/Modules/Application/Controller/d3_oxshopcontrol_modcfg_extension',
        OxidCore\Theme::class => 'd3/modcfg/Modules/Core/d3_oxtheme_modcfg',
        OxidCore\UtilsView::class => 'd3/modcfg/Modules/Core/d3_oxutilsview_modcfg',
// ToDo: check, if we can enable this
        // OxidCore\Email::class => 'd3/modcfg/Modules/Core/d3_oxemail_log',
        # see at end of file for further dynamic extensions
    ],
    'files'       => [
        ModuleAdminController\d3_cfg_mod_::class          => 'd3/modcfg/Application/Controller/Admin/d3_cfg_mod_.php',
        ModuleAdminController\d3_cfg_mod_licence::class   => 'd3/modcfg/Application/Controller/Admin/d3_cfg_mod_licence.php',
        ModuleAdminController\d3_cfg_mod_list::class      => 'd3/modcfg/Application/Controller/Admin/d3_cfg_mod_list.php',
        ModuleAdminController\d3_cfg_mod_main::class      => 'd3/modcfg/Application/Controller/Admin/d3_cfg_mod_main.php',

        ModuleAdminCnfController\d3mod_status::class      => 'd3/modcfg/Application/Controller/Admin/Configuration/d3mod_status.php',
        ModuleAdminCnfController\d3modext::class          => 'd3/modcfg/Application/Controller/Admin/Configuration/d3modext.php',
        ModuleAdminCnfController\d3modext_list::class     => 'd3/modcfg/Application/Controller/Admin/Configuration/d3modext_list.php',
        ModuleAdminCnfController\d3modext_status::class   => 'd3/modcfg/Application/Controller/Admin/Configuration/d3modext_status.php',
        ModuleAdminCnfController\d3modext_new::class      => 'd3/modcfg/Application/Controller/Admin/Configuration/d3modext_new.php',
        ModuleAdminCnfController\d3modlib::class          => 'd3/modcfg/Application/Controller/Admin/Configuration/d3modlib.php',
        ModuleAdminCnfController\d3modlib_list::class     => 'd3/modcfg/Application/Controller/Admin/Configuration/d3modlib_list.php',
        ModuleAdminCnfController\d3modlib_status::class   => 'd3/modcfg/Application/Controller/Admin/Configuration/d3modlib_status.php',
        ModuleAdminCnfController\d3modlib_support::class  => 'd3/modcfg/Application/Controller/Admin/Configuration/d3modlib_support.php',

        ModuleAdminInstallController\d3_mod_install::class   => 'd3/modcfg/Application/Controller/Admin/Install/d3_mod_install.php',
        ModuleAdminInstallController\d3_mod_update::class    => 'd3/modcfg/Application/Controller/Admin/Install/d3_mod_update.php',
        ModuleAdminInstallController\d3mod_activation::class => 'd3/modcfg/Application/Controller/Admin/Install/d3mod_activation.php',

        ModuleAdminLogController\d3_cfg_log::class          => 'd3/modcfg/Application/Controller/Admin/Log/d3_cfg_log.php',
        ModuleAdminLogController\d3_cfg_log_cleanup::class  => 'd3/modcfg/Application/Controller/Admin/Log/d3_cfg_log_cleanup.php',
        ModuleAdminLogController\d3_cfg_log_list::class     => 'd3/modcfg/Application/Controller/Admin/Log/d3_cfg_log_list.php',
        ModuleAdminLogController\d3_cfg_log_main::class     => 'd3/modcfg/Application/Controller/Admin/Log/d3_cfg_log_main.php',

        ModuleAdminMntController\d3cfgitems::class          => 'd3/modcfg/Application/Controller/Admin/Maintenance/d3cfgitems.php',
        ModuleAdminMntController\d3cleartmp::class          => 'd3/modcfg/Application/Controller/Admin/Maintenance/d3cleartmp.php',
        ModuleAdminMntController\d3cleartmp_frame::class    => 'd3/modcfg/Application/Controller/Admin/Maintenance/d3cleartmp_frame.php',
        ModuleAdminMntController\d3cleartmp_list::class     => 'd3/modcfg/Application/Controller/Admin/Maintenance/d3cleartmp_list.php',
        ModuleAdminMntController\d3maintenance::class       => 'd3/modcfg/Application/Controller/Admin/Maintenance/d3maintenance.php',
        ModuleAdminMntController\d3moditems::class          => 'd3/modcfg/Application/Controller/Admin/Maintenance/d3moditems.php',
        ModuleAdminMntController\d3shopmaintenance::class   => 'd3/modcfg/Application/Controller/Admin/Maintenance/d3shopmaintenance.php',
        ModuleAdminMntController\d3sysitems::class          => 'd3/modcfg/Application/Controller/Admin/Maintenance/d3sysitems.php',
        ModuleAdminMntController\d3sysitems_list::class     => 'd3/modcfg/Application/Controller/Admin/Maintenance/d3sysitems_list.php',

        ModuleModel\d3bit::class            => 'd3/modcfg/Application/Model/d3bit.php',
        ModuleModel\d3database::class       => 'd3/modcfg/Application/Model/d3database.php',
        ModuleModel\d3feeds::class          => 'd3/modcfg/Application/Model/d3feeds.php',
        ModuleModel\d3pagenavigation::class => 'd3/modcfg/Application/Model/d3pagenavigation.php',
        ModuleModel\d3tickercontrol::class  => 'd3/modcfg/Application/Model/d3tickercontrol.php',
        ModuleModel\d3counter::class        => 'd3/modcfg/Application/Model/d3counter.php',
        ModuleModel\d3utils::class          => 'd3/modcfg/Application/Model/d3utils.php',
        ModuleModel\d3selection::class      => 'd3/modcfg/Application/Model/d3selection.php',
        ModuleModel\d3filesystem::class     => 'd3/modcfg/Application/Model/d3filesystem.php',
        ModuleModel\d3remotecache::class    => 'd3/modcfg/Application/Model/d3remotecache.php',
        ModuleModel\d3module::class         => 'd3/modcfg/Application/Model/d3module.php',

        ModuleModel\d3simplexml::class      => 'd3/modcfg/Application/Model/d3simplexml.php',
        ModuleModel\d3str::class            => 'd3/modcfg/Application/Model/d3str.php',
        ModuleModel\d3stream::class         => 'd3/modcfg/Application/Model/d3stream.php',
        ModuleModel\d3webdav::class         => 'd3/modcfg/Application/Model/d3webdav.php',


        ModuleCnfModel\d3_cfg_mod::class            => 'd3/modcfg/Application/Model/Configuration/d3_cfg_mod.php',
        ModuleCnfModel\d3_cfg_mod_variant::class    => 'd3/modcfg/Application/Model/Configuration/d3_cfg_mod_variant.php',
        ModuleCnfModel\d3modprofile::class          => 'd3/modcfg/Application/Model/Configuration/d3modprofile.php',
        ModuleCnfModel\d3modprofileList::class      => 'd3/modcfg/Application/Model/Configuration/d3modprofilelist.php',

        ModuleEncModel\d3decoder::class => 'd3/modcfg/Application/Model/Encoding/d3decoder.php',
        ModuleEncModel\d3encoder::class => 'd3/modcfg/Application/Model/Encoding/d3encoder.php',

        ModuleExcModel\d3_cfg_mod_exception::class                  => 'd3/modcfg/Application/Model/Exception/d3_cfg_mod_exception.php',
        ModuleExcModel\d3modprofile_exception::class                => 'd3/modcfg/Application/Model/Exception/d3modprofile_exception.php',
        ModuleExcModel\d3log_exception::class                       => 'd3/modcfg/Application/Model/Exception/d3log_exception.php',
        ModuleExcModel\d3ParameterNotFoundException::class          => 'd3/modcfg/Application/Model/Exception/d3parameternotfoundexception.php',
        ModuleExcModel\d3shopcompatibilityadapterexception::class   => 'd3/modcfg/Application/Model/Exception/d3shopcompatibilityadapterexception.php',

        ModuleFlgModel\d3filegenerator::class       => 'd3/modcfg/Application/Model/Filegenerator/d3filegenerator.php',
        ModuleFlgModel\d3filegeneratorcronsh::class => 'd3/modcfg/Application/Model/Filegenerator/d3filegeneratorcronsh.php',

        ModuleInsModel\d3install::class             => 'd3/modcfg/Application/Model/Install/d3install.php',
        ModuleInsModel\d3install_updatebase::class  => 'd3/modcfg/Application/Model/Install/d3install_updatebase.php',
        ModuleInsModel\d3updateinstaller::class     => 'd3/modcfg/Application/Model/Install/d3updateinstaller.php',

        ModuleIncModel\d3installcheck::class                            => 'd3/modcfg/Application/Model/Installcheck/d3installcheck.php',
        ModuleIncModel\d3InstallCheckInterface::class                   => 'd3/modcfg/Application/Model/Installcheck/d3InstallCheckInterface.php',
        ModuleIncModel\d3InstallCheckModuleVersionsIdentical::class     => 'd3/modcfg/Application/Model/Installcheck/d3InstallCheckModuleVersionsIdentical.php',
        ModuleIncModel\d3InstallCheckExtendItemsAreActive::class        => 'd3/modcfg/Application/Model/Installcheck/d3InstallCheckExtendItemsAreActive.php',
        ModuleIncModel\d3InstallCheckClassItemsAreAvailable::class      => 'd3/modcfg/Application/Model/Installcheck/d3InstallCheckClassItemsAreAvailable.php',
        ModuleIncModel\d3InstallCheckTemplateItemsAreAvailable::class   => 'd3/modcfg/Application/Model/Installcheck/d3InstallCheckTemplateItemsAreAvailable.php',
        ModuleIncModel\d3InstallCheckBlockItemsAreActive::class         =>  'd3/modcfg/Application/Model/Installcheck/d3InstallCheckBlockItemsAreActive.php',
        ModuleIncModel\d3InstallCheckHasNoInstallItem::class            => 'd3/modcfg/Application/Model/Installcheck/d3InstallCheckHasNoInstallItem.php',

        ModuleInwModel\d3installaction::class               => 'd3/modcfg/Application/Model/Installwizzard/d3installaction.php',
        ModuleInwModel\d3installdatahandler::class          => 'd3/modcfg/Application/Model/Installwizzard/d3installdatahandler.php',
        ModuleInwModel\d3installcleandbstructurelist::class => 'd3/modcfg/Application/Model/Installwizzard/d3installcleandbstructurelist.php',
        ModuleInwModel\d3install2shoprelation::class        => 'd3/modcfg/Application/Model/Installwizzard/d3install2shoprelation.php',
        ModuleInwModel\d3installdbtable::class              => 'd3/modcfg/Application/Model/Installwizzard/d3installdbtable.php',
        ModuleInwModel\d3installdbtablemultilang::class     => 'd3/modcfg/Application/Model/Installwizzard/d3installdbtablemultilang.php',
        ModuleInwModel\d3installdbtablemultishop::class     => 'd3/modcfg/Application/Model/Installwizzard/d3installdbtablemultishop.php',
        ModuleInwModel\d3installdbfield::class              => 'd3/modcfg/Application/Model/Installwizzard/d3installdbfield.php',
        ModuleInwModel\d3installdbfieldmultilang::class     => 'd3/modcfg/Application/Model/Installwizzard/d3installdbfieldmultilang.php',
        ModuleInwModel\d3installdbfieldcollation::class     => 'd3/modcfg/Application/Model/Installwizzard/d3installdbfieldcollation.php',
        ModuleInwModel\d3installdbindizes::class            => 'd3/modcfg/Application/Model/Installwizzard/d3installdbindizes.php',
        ModuleInwModel\d3installdbrecord::class             => 'd3/modcfg/Application/Model/Installwizzard/d3installdbrecord.php',
        ModuleInwModel\d3installdbrecordmultilang::class    => 'd3/modcfg/Application/Model/Installwizzard/d3installdbrecordmultilang.php',
        ModuleInwModel\d3installconfirmmessage::class       => 'd3/modcfg/Application/Model/Installwizzard/d3installconfirmmessage.php',
        ModuleInwModel\d3installupdatefile::class           => 'd3/modcfg/Application/Model/Installwizzard/d3installupdatefile.php',
        ModuleInwModel\d3installdbcommon::class             => 'd3/modcfg/Application/Model/Installwizzard/d3installdbcommon.php',
        ModuleInwModel\d3installoxconfig::class             => 'd3/modcfg/Application/Model/Installwizzard/d3installoxconfig.php',
        ModuleInwModel\d3installmodule::class               => 'd3/modcfg/Application/Model/Installwizzard/d3installmodule.php',
        ModuleInwModel\d3installmodcfg::class               => 'd3/modcfg/Application/Model/Installwizzard/d3installmodcfg.php',
        ModuleInwModel\d3installskipupdate::class           => 'd3/modcfg/Application/Model/Installwizzard/d3installskipupdate.php',
        ModuleInwModel\d3installskipjob::class              => 'd3/modcfg/Application/Model/Installwizzard/d3installskipjob.php',
        ModuleInwModel\d3installfile::class                 => 'd3/modcfg/Application/Model/Installwizzard/d3installfile.php',

        ModuleLogModel\d3log::class => 'd3/modcfg/Application/Model/Log/d3log.php',

        ModuleMntModel\d3maintenanceactions::class =>   'd3/modcfg/Application/Model/Maintenance/d3maintenanceactions.php',
        ModuleMntModel\d3clrtmp::class             => 'd3/modcfg/Application/Model/Maintenance/d3clrtmp.php',

        ModulePcnModel\d3ParameterContainer::class          => 'd3/modcfg/Application/Model/Parametercontainer/d3parametercontainer.php',
        ModulePcnModel\d3ParameterContainerInterface::class => 'd3/modcfg/Application/Model/Parametercontainer/d3parametercontainerinterface.php',

        ModuleCmpModel\d3shopcompatibilityadapterhandler::class     => 'd3/modcfg/Application/Model/Shopcompatibility/d3shopcompatibilityadapterhandler.php',
        ModuleCmpModel\d3shopcompatibilityadapterinterface::class   => 'd3/modcfg/Application/Model/Shopcompatibility/d3shopcompatibilityadapterinterface.php',
        ModuleCmpModel\d3shopcompatibility60adapter::class          => 'd3/modcfg/Application/Model/Shopcompatibility/d3shopcompatibility60adapter.php',
        ModuleCmpModel\d3shopversionconverter::class                => 'd3/modcfg/Application/Model/Shopcompatibility/d3shopversionconverter.php',

        ModuleTalModel\d3transactionlog::class          => 'd3/modcfg/Application/Model/Transactionlog/d3transactionlog.php',
        ModuleTalModel\d3transactionloglist::class      => 'd3/modcfg/Application/Model/Transactionlog/d3transactionloglist.php',
        ModuleTalModel\Reader\AbstractReader::class     => 'd3/modcfg/Application/Model/Transactionlog/Reader/AbstractReader.php',
        ModuleTalModel\object2d3transactionlog::class   => 'd3/modcfg/Application/Model/Transactionlog/object2d3transactionlog.php',

        ModuleSetup\Events::class               => 'd3/modcfg/setup/Events.php',
        ModuleSetup\d3_cfg_mod_update::class    => 'd3/modcfg/setup/d3_cfg_mod_update.php',
        ModuleSetup\d3_cfg_mod_cleaning::class  => 'd3/modcfg/setup/d3_cfg_mod_cleaning.php',
        ModuleSetup\d3log_update::class         => 'd3/modcfg/setup/d3log_update.php',

        ModuleAdminTplController\d3tplblocks::class         => 'd3/modcfg/Application/Controller/Admin/TPLBlocks/d3tplblocks.php',
        ModuleAdminTplController\d3tplblocks_list::class    => 'd3/modcfg/Application/Controller/Admin/TPLBlocks/d3tplblocks_list.php',
        ModuleAdminTplController\d3tplblocks_main::class    => 'd3/modcfg/Application/Controller/Admin/TPLBlocks/d3tplblocks_main.php',
        ModuleAdminTplController\d3tplblocks_extend::class  => 'd3/modcfg/Application/Controller/Admin/TPLBlocks/d3tplblocks_extend.php',
        ModuleModel\d3oxtplblocks::class                    => 'd3/modcfg/Application/Model/d3oxtplblocks.php',
    ],
    'blocks'      => [],
    'settings'    => [
        [
            'group' => 'd3thememapping_global',
            'name' => 'd3custParentThemeMappedToFlow_'.$sModuleId,
            'type' => 'str',
        ],
        [
            'group' => 'd3thememapping_global',
            'name' => 'd3custParentThemeMappedToMobile_'.$sModuleId,
            'type' => 'str',
        ],
        [
            'group' => 'd3thememapping_global',
            'name' => 'd3custParentThemeMappedToAzure_'.$sModuleId,
            'type' => 'str',
        ],
    ],
    'templates'   => [
        #d3_cfg_mod
        'd3_cfg_mod_.tpl'       => 'd3/modcfg/Application/views/admin/tpl/d3_cfg_mod_.tpl',
        'd3_adm_header.tpl'     => 'd3/modcfg/Application/views/admin/tpl/d3_adm_header.tpl',
        'd3_adm_navigation.tpl' => 'd3/modcfg/Application/views/admin/tpl/d3_adm_navigation.tpl',
        'd3_cfg_mod_inc.tpl'    => 'd3/modcfg/Application/views/admin/tpl/inc/d3_cfg_mod_inc.tpl',
        'd3_cfg_mod_bottom.tpl' => 'd3/modcfg/Application/views/admin/tpl/inc/d3_cfg_mod_bottom.tpl',
        'd3_cfg_mod_active.tpl' => 'd3/modcfg/Application/views/admin/tpl/inc/d3_cfg_mod_active.tpl',
        'd3_modprofile_actionbuttons.tpl'  => 'd3/modcfg/Application/views/admin/tpl/inc/d3_modprofile_actionbuttons.tpl',
        'd3_cfg_mod_licence.tpl'=> 'd3/modcfg/Application/views/admin/tpl/d3_cfg_mod_licence.tpl',
        'd3_cfg_mod_list.tpl'   => 'd3/modcfg/Application/views/admin/tpl/d3_cfg_mod_list.tpl',
        'd3_cfg_mod_main.tpl'   => 'd3/modcfg/Application/views/admin/tpl/d3_cfg_mod_main.tpl',
        'd3cfgitems.tpl'        => 'd3/modcfg/Application/views/admin/tpl/Maintenance/d3cfgitems.tpl',
        'd3modcfg_lib_cfg.tpl'  => 'd3/modcfg/Application/views/admin/tpl/d3modcfg_lib_cfg.tpl',
        'd3moditems.tpl'        => 'd3/modcfg/Application/views/admin/tpl/Maintenance/d3moditems.tpl',
        'd3modlib_status.tpl'   => 'd3/modcfg/Application/views/admin/tpl/Configuration/d3modlib_status.tpl',
        'd3mod_activation.tpl'  => 'd3/modcfg/Application/views/admin/tpl/Install/d3mod_activation.tpl',
        'd3maintenance.tpl'     => 'd3/modcfg/Application/views/admin/tpl/Maintenance/d3maintenance.tpl',
        'd3pagenavigation.tpl'  => 'd3/modcfg/Application/views/admin/tpl/d3pagenavigation.tpl',

        #d3install
        'd3_mod_install.tpl'    => 'd3/modcfg/Application/views/admin/tpl/Install/d3_mod_install.tpl',
        'd3_mod_update.tpl'     => 'd3/modcfg/Application/views/admin/tpl/Install/d3_mod_update.tpl',
        'd3install_lib_cfg.tpl' => 'd3/modcfg/Application/views/admin/tpl/Install/d3install_lib_cfg.tpl',

        #d3log
        'd3_cfg_log_cleanup.tpl'=> 'd3/modcfg/Application/views/admin/tpl/Log/d3_cfg_log_cleanup.tpl',
        'd3_cfg_log_list.tpl'   => 'd3/modcfg/Application/views/admin/tpl/Log/d3_cfg_log_list.tpl',
        'd3_cfg_log_main.tpl'   => 'd3/modcfg/Application/views/admin/tpl/Log/d3_cfg_log_main.tpl',
        'd3log_lib_cfg.tpl'     => 'd3/modcfg/Application/views/admin/tpl/Log/d3log_lib_cfg.tpl',
        'd3loglevel_form.tpl'   => 'd3/modcfg/Application/views/admin/tpl/inc/d3loglevel_form.tpl',

        #d3cleartmp
        'd3cleartmp.tpl'        => 'd3/modcfg/Application/views/admin/tpl/Maintenance/d3cleartmp.tpl',
        'd3clrtmp_lib_cfg.tpl'  => 'd3/modcfg/Application/views/admin/tpl/Maintenance/d3clrtmp_lib_cfg.tpl',
        'd3shopmaintenance.tpl' => 'd3/modcfg/Application/views/admin/tpl/Maintenance/d3shopmaintenance.tpl',

        'd3tplblocks_list.tpl'  => 'd3/modcfg/Application/views/admin/tpl/TPLBlocks/d3tplblocks_list.tpl',
        'd3tplblocks_main.tpl'  => 'd3/modcfg/Application/views/admin/tpl/TPLBlocks/d3tplblocks_main.tpl',
        'd3tplblocks_extend.tpl'=> 'd3/modcfg/Application/views/admin/tpl/TPLBlocks/d3tplblocks_extend.tpl',
    ],
    'events'      => [
        'onActivate'    => '\D3\ModCfg\setup\Events::onActivate',
        'onDeactivate'  => '\D3\ModCfg\setup\Events::onDeactivate',
    ],

    'd3FileRegister'    => [
        'd3/modcfg/metadata.php',
        'd3/modcfg/IntelliSenseHelper.php',
        'd3/modcfg/Core/Smarty/Plugin/block.d3modcfgcheck.php',
        'd3/modcfg/Core/Smarty/Plugin/function.d3getobject.php',
        'd3/modcfg/public/d3logo.php',
        'd3/modcfg/Application/translations/de/d3modcfg_lang.php',
        'd3/modcfg/Application/translations/en/d3modcfg_lang.php',
        'd3/modcfg/Application/views/admin/de/d3clrtmp_lang.php',
        'd3/modcfg/Application/views/admin/de/d3log_lang.php',
        'd3/modcfg/Application/views/admin/de/d3modcfg_lang.php',
        'd3/modcfg/Application/views/admin/de/d3modinstall_lang.php',
        'd3/modcfg/Application/views/admin/de/module_options.php',
        'd3/modcfg/Application/views/admin/en/d3clrtmp_lang.php',
        'd3/modcfg/Application/views/admin/en/d3log_lang.php',
        'd3/modcfg/Application/views/admin/en/d3modcfg_lang.php',
        'd3/modcfg/Application/views/admin/en/d3modinstall_lang.php',
        'd3/modcfg/Application/views/admin/en/module_options.php',
        'd3/modcfg/Modules/Application/Controller/Admin/d3_roles_bemain_rolesrights.php', // in PE + CE it's not registered
        'd3/modcfg/Modules/Core/d3_oxemail_log.php',
        'd3/modcfg/public/d3modcfg_maintenance.php',
        'd3/modcfg/Application/views/admin/tpl/modcfg-pattern/d3shpattern_cron_domainfactory56.tpl',
        'd3/modcfg/Application/views/admin/tpl/modcfg-pattern/d3shpattern_cron_domainfactory70.tpl',
        'd3/modcfg/Application/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner56cgi.tpl',
        'd3/modcfg/Application/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner56cli.tpl',
        'd3/modcfg/Application/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner70cgi.tpl',
        'd3/modcfg/Application/views/admin/tpl/modcfg-pattern/d3shpattern_cron_hetzner70cli.tpl',
        'd3/modcfg/Application/views/admin/tpl/modcfg-pattern/d3shpattern_cron_mittwald.tpl',
        'd3/modcfg/Application/views/admin/tpl/modcfg-pattern/d3shpattern_cron_profihost56.tpl',
        'd3/modcfg/Application/views/admin/tpl/modcfg-pattern/d3shpattern_cron_profihost70.tpl',
        'd3/modcfg/Application/views/admin/tpl/modcfg-pattern/d3shpattern_cron_standard.tpl',
    ],
    'd3SetupClasses'    => [
        ModuleSetup\d3_cfg_mod_update::class,
        ModuleSetup\d3log_update::class,
    ],
];

// EE only
// check for compatible roles_bemain class, if it's missing, extension causes some autoload errors
if (class_exists(OxidAdminController\RolesBackendMain::class)) {
    $aModule['extend'][OxidAdminController\RolesBackendMain::class] = 'd3/modcfg/Modules/Application/Controller/Admin/d3_roles_bemain_rolesrights';
}
