# D Modul Connector - Changelog
All notable changes to this project will be documented in this file.

## Table of Contents
- [Unreleased](#cUnreleased)
- [5.1.0.1](#c5101)
- [5.1.0.0](#c5100)
- [5.0.0.0](#c5000)
- [4.5.0.0](#c4500)
- [4.4.1.0](#c4410)
- [4.4.0.0](#c4400)
- [4.3.7.0](#c4370)
- [4.3.6.2](#c4362)
- [4.3.6.1](#c4361)
- [4.3.6.0](#c4360)
- [4.3.5.0](#c4350)
- [4.3.4.1](#c4341)
- [4.3.4.0](#c4340)
- [4.3.3.7](#c4337)
- [4.3.3.6](#c4336)
- [4.3.3.5](#c4335)
- [4.3.3.4](#c4334)
- [4.3.3.3](#c4333)
- [4.3.3.2](#c4332)
- [4.3.3.1](#c4331)
- [4.3.3.0](#c4330)
- [4.3.2.2](#c4322)
- [4.3.2.1](#c4321)
- [4.3.2.0](#c4320)
- [4.3.1.1](#c4311)
- [4.3.1.0](#c4310)
- [4.3.0.0](#c4300)
- [4.2.2.0](#c4220)
- [4.2.1.0](#c4210)
- [4.2.0.1](#c4201)
- [4.2.0.0](#c4200)
- [4.1.0.1](#c4101)
- [4.1.0.0](#c4100)
- [4.0.2.0](#c4020)
- [4.0.1.0](#c4010)
- [4.0.0.2](#c4002)
- [4.0.0.1](#c4001)
- [4.0.0.0](#c4000)

## Unreleased<a name="cUnreleased"></a>

## 5.1.0.1 - 2018-04-26<a name="c5101"></a>
### Changed
- Klassenname von d3counter korrigiert

## 5.1.0.0 - 2017-12-18<a name="c5100"></a>
### Added
- composerfhige Installation
- Migrationsqueries (von OXID 4.10 / 5.x)
- Bereinigung der genierten Bilder auch fr andere Objekttypen

### Changed
- als deprecated markierten Code entfernt

## 5.0.0.0 - 2017-11-23<a name="c5000"></a>
### Added
- Log-Export auch fr modulspezifische Log-Auswertungen mglich
- Template-Block-Verwaltung eingefgt
- Versionsnummern-Konverter fr sauberes Handling mit der B2B-Edition integriert

### Changed
- Umarbeitung fr OXID 6

## 4.5.0.0<a name="c4500"></a>
- Icon-Bibliothek Font Awesome auf Version 4.7.0 aktualisiert
- Admin-Url-Generator korrigiert (verhindert seltenes Logout beim Verwenden dieser URLs)
- Filter fr Transactionlog eingefgt
- #5718 + #5717: zustzliche Indizes fr d3tranactionlog und zugehrige Tabellen gesetzt
- #5740: Tabellenengines auf InnoDB umgestellt
- #5684: Log-Exporttyp "CSV" entfernt
- ClearTmp-Infobereich umgestellt
- Modul auf ionCube-Verwendung angepasst
- Dashboard zeigt Informationen zu relevanten Expire-Dates der installierten Module
- Testlizenzen werden im Modulnamen entsprechend dargestellt
- cURL folgt Redirect-Angaben
- Lizenz prft Shop-Edition
- Feature-Bits integriert
- Zeichensatz-Vorbelegung fr Update-Dateien eingefgt
- Remotecache optimiert
- Hinweis bei versuchter Deaktivierung des Modul-Connectors eingefgt
- Protokoll von allgemeinen Shop-Exceptions werden nicht dem Connector zugeordnet
- Update- und Lizenzserver werden ber https angesprochen
- Modul-Titel in UTF-8-Installationen korrigiert
- SQL-Exporte korrigiert
- #6329: fehlerhafte Datenbankstruktur bei lckenhaften Sprach-IDs korrigiert

## 4.4.1.0<a name="c4410"></a>
- Meldung ber unerfllte Connector-Abhngigkeit kann temporr bergangen werden
- "Lizenzdetails" zeigt auch kompletten Lizenzschlssel
- automatische Installation: Interaktion mit Backenduser fr kundenspezifische Installation (#5549)
- Theme-Mapping auf modulspezifische Variablennamen umgestellt
- Code-Optimierungen, um Notices zu vermeiden

## 4.4.0.0<a name="c4400"></a>
- verarbeitet mCrypt-vermeidende Lizenzinformationen
- Theme-Mapping eingefgt
- konfigurierbare Mandantenunabhngigkeit bei relevanten Installationsaufgaben eingefgt
- d3log-Tabellenstruktur optimiert
- Logtyp-Listen werden nach Prioritt sortiert
- fr Einsatz mit ionCubeLoader (anstelle von Zend Guard) angepasst (#5489)
- veraltete Methodenaufrufe ersetzt
- .htaccess-nderungen fr Apache 2.4 korrigiert

## 4.3.7.0<a name="c4370"></a>
- Installationsassistent: Funktion zur nderung der Tabellen-Engine eingefgt
- .htaccess-nderungen fr Apache 2.4 eingefgt

## 4.3.6.2<a name="c4362"></a>
- Lizenzablehnungsgrnde werden in Log-Tabelle geschrieben
- Hintergrund-Logo in Adminbereichen entfernt

## 4.3.6.1<a name="c4361"></a>
- Fehlerbehebung fr nicht verfgbares Objekt whrend Neuinstallation

## 4.3.6.0<a name="c4360"></a>
- Methode zur Ermittlung der Parent-Theme-Id eingefgt
- Systembefehle knnen als klickbare Wartungsaufgaben eingerichtet werden (Ausfhrbarkeit via PHP vorausgesetzt)
- "TMP leeren" ist als "ausblendbar" konfigurierbar
- Connector-Versions-Prfung fr Module optimiert
- "TMP leeren"-Optik an eShop 4.10.x angepasst
- Downloads bercksichtigen PHP 5.5 und 5.6
- Admin-Layout fr optimale Darstellung der Module angepasst (deaktivierbar)
- D3-Logo im Backend wird via SSL geladen, wenn SSL aktiviert
- Menicons eingefgt
- Log fr Lizenzabfrage eingefgt
- Seitentitel korrigiert

## 4.3.5.0<a name="c4350"></a>
- Kompatibilitt fr OXID 4.10.x / 5.3.x eingefgt
- nicht funktionierenden Entwicklermodus korrigiert
- Icons auf FontAwesome-Schriftarten umgestellt
- Modulinstallation prft auf vordefinierte Connectorversion (sofern im Modul angegeben)
- fehlende Templateparameter ergnzt

## 4.3.4.1<a name="c4341"></a>
- "verfgbare Module"-Liste berarbeitet
- Laden vom ModCfg-Instanzen bei Mandantenwechsel optimiert
- Bugfix fr gelschte Multishop-Tabellen-Standardeintrge
- vermeidet Initialisierung eines undefinierten List-Objektes in Adminlist

## 4.3.4.0<a name="c4340"></a>
- zustzliche Indizes zu log2transactionlog-Tabelle eingefgt
- vermeidet die Verwendung mehrerer oxconfig-Instanzen
- Shoprevisionsprfung korrigiert
- Portnummernprfung in Domaincheck eingefgt (#4875)
- Bugfix fr Install/Update von ModCfg-Eintrgen in Multishopinstallationen
- Aktualisierung der Metadaten berarbeitet

## 4.3.3.7<a name="c4337"></a>
- Mandantenwechsel in automatischer Installation fr berladene oxconfig-Klasse angepasst
- Prfen-Funktion in Wartung integriert
- ModCfgExceptions um zustzliche Debug-Daten ergnzt
- Navigationslinks in PageNavigation um Sprachparameter des Frontends ergnzt
- fehlendes oxtimestamp-Feld nachgetragen
- Multimandanteninstallation ber config-Parameter deaktivierbar (nur EE)

## 4.3.3.6<a name="c4336"></a>
- Beschreibungstext fr Installationsschritte eingefgt
- Multishop-Installation optimiert
- Fehler bei Standard-Datenbankfeldwerten = null korrigiert
- unbekannte (unbenutzte) Lizenzoptionen werden ausgeblendet

## 4.3.3.5<a name="c4335"></a>
- Lizenzprfung optimiert
- Bugfix fr wechselnde Installationsmethode bei Meldungsaktion
- Bugfix fr fehlerhaft zusammengestellte SQL-Queries bei primary indexes
- Bugfix fr Fehlermeldung bei differierenden Modulversionsnummern im Support-Tab

## 4.3.3.4<a name="c4334"></a>
- Eingabefeld fr Aktivierungsident und Lizenzschlssel zusammengefasst
- Installationstemplates optimiert
- Auflistung der Updatescripte prft auf Existenz der Verzeichnisse innerhalb der OXID-Verzeichnisliste
- Bugfix fr unvollstndige Datenbankabfrage bei individuellen oxartextends-Felder innerhalb der Wartungsaufgaben
- Installationsassistent: Endlosschleife bei "Meldung besttigen" in bestimmten Konstallationen korrigiert
- Deinstallationsanleitung in Dokumentation aufgenommen

## 4.3.3.3<a name="c4333"></a>
- Bugfix fr falsche Methodendefinition in 4.7/4.8
- Admin-Templates optimiert

## 4.3.3.2<a name="c4332"></a>
- Wartungsaufgaben von Nicht-Shop-Standardfeldern bereinigt
- Installationsassistent: Index-Cache-Nutzung bei "Tabelle erstellen" optimiert
- Installationsassistent: Ausfhrung im Debug-Modus korrigiert
- Installationsassistent: Prfung auf veraltete Indizes
- Installationsassistent: Metarefresh wird nur fr registrierte Module ausgefhrt
- Installationsassistent: veraltete Parameter entfernt
- Installationsassistent: temporre Aktion wird generell zurckgesetzt
- Update-Scriptliste optimiert
- Fehler bei nicht sofort verfgbarer oxmodule-Erweiterung unterbunden
- Installationsassistent: "Meldung besttigen" korrigiert
- Precheck auf aktuelle Version angepasst
- Endlosschleife bei Updates von alten Connector-Versionen beseitigt
- Exceptionbehandlung fr Fehler beim Laden des Konfigurationsobjektes eingefgt
- Notices werden in Scriptdurchlauf vermieden

## 4.3.3.1<a name="c4331"></a>
- Moduldownloads fr automatische Updates an Servernderungen angepasst
- Fehlerprotokoll fr abgebrochene curl-Verbindungen eingefgt
- Precheck angepasst

## 4.3.3.0<a name="c4330"></a>
- SH-Generator um neue PHP-Versionen vervollstndigt
- Bugfix in Installationsautomatik bei Installation des FileUpload-Moduls
- unntige Index-Konvertierungen beim Anlegen neuer Tabellen korrigiert

## 4.3.2.2<a name="c4322"></a>
- verhindert noch nicht verfgbares Update unter PHP 5.5 / PHP 5.6

## 4.3.2.1<a name="c4321"></a>
- keine "Ungltige Lizenz"-Ausnahmebehandlung bei inaktiven Modulen in Modulverwaltung (z.B. beim Ersteintrag des Lizenzschlssels)
- Installationsoption "Indizes prfen" prft auf passende Feldliste
- Sprachermittlung aus Datenbankfeldnamen korrigiert

## 4.3.2.0<a name="c4320"></a>
- Konfigurationsvariante integriert
- Fehlerbehandlung optimiert
- Datenbankabfragen optimiert
- Installationsassistent: Eintragskonvertierung fr Multilang-Tabellen angepasst
- Installationsassistent: Update-Queries werden um nicht definierte Felder vervollstndigt
- Installationsassistent: Einfge-Operation versucht nicht, bisherige Datenbankeintrge zu laden
- Installationsassistent: Update-Query vervollstndigen Multilang-Tabellen
- Installationsassistent: Suchalgorithmus fr Setup-Anweisungsdateien optimiert
- Installationsassistent: case insensitivity in Enum-Feldtypprfung integriert

## 4.3.1.1<a name="c4311"></a>
- Abbruch von Modulinstallation durch fehlerhaft generierte Datenbankabfrage beseitigt

## 4.3.1.0<a name="c4310"></a>
- veraltete Moduldateien werden gelscht
- fehlerhafte Vervollstndigung zu aktualisierender Datenbankeintrge korrigiert
- Dateilisten-Cache optimiert
- Prfung auf nicht genutzte Dateien verwendet "block"-Eintrge aus metadata
- konfigurierbare Pagination
- Installationsoption "confirmMessage" optimiert

## 4.3.0.0<a name="c4300"></a>
- Verwendung von Multilang- und Multishop-Tabellen (via View-Tabellen) statt interner Anpassung
- Installationsoption: Anzeige unregistrierter Moduldateien
- Installationsoption: DB-Strukturnderungen (Felder / Indizes) knnen einzeln aktualisiert werden
- Installationsoption: confirmMessage speichert Confirmation
- nicht mehr verwendete Installsteps (Version 1) entfernt
- bersprungene Installationsschritte gelten nur noch fr spezifische Modulversion
- Blog Feed Caching integriert
- (optionale) Modulaktivierung in automatische Installation eingefgt

## 4.2.2.0<a name="c4220"></a>
- Kompatibilittshandling fr oxmodule::getModuleFullPath eingefgt
- Anpassung der Lesereihenfolge fr Remoteaufrufe

## 4.2.1.0<a name="c4210"></a>
- erweitertes Caching fr Updateinformationen integriert (#3267)
- SH-Generator integriert (#3236)
- Multishop-Registrierung (EE) fr automatische Installation integriert (#3248)
- Modulprofile erhalten Multishophandling (ab EE 5.2.0)
- fehlertolerantere Abfrage auf "duplicated tpl blocks"

## 4.2.0.1<a name="c4201"></a>
- nicht verwendete Klassen aus metadata entfernt
- Precheck um weitere Anforderungen ergnzt
- Remote module data werden gecached
- Modulupdates werden nur fr den aktuellen Mandanten geprft (nur EE)
- Shopbit-Berechnung nach d3bit verschoben

## 4.2.0.0<a name="c4200"></a>
- Umsetzung fr OXID 4.9 / 5.2 (abwrts kompatibel bis 4.7 / 5.0)

## 4.1.0.1<a name="c4101"></a>
- Bugfix fr nicht ausfhrbares TMP leeren whrend Connector-Installation integriert

## 4.1.0.0<a name="c4100"></a>
- Wartungsfunktionen eingefgt
- Modulprofile knnen Datentyp wechseln
- Empfnger fr Lizenzhinweis-Mails ist anpassbar
- Schnellzugriff fr TMP leeren integriert
- Modulauflistungen werden sortiert
- TMP leeren kann vordefinierte Dateien vom Lschen aussparen
- Installationsoption "alte Moduldateien lschen" integriert

## 4.0.2.0<a name="c4020"></a>
- fehlende Klassenregistrierung "d3_cfg_log_cleanup" nachgetragen
- Installationsoption "einmalige Hinweismeldung" integriert
- Mehrfachmeldungen bei veralteter Lizenz korrigiert

## 4.0.1.0<a name="c4010"></a>
- Ablsung der manuell gepflegten Anforderungsprfung zur automatischen Installationsprfung
- Bugfix fr d3log-Exception bei Fehler 404-Seite eingefgt

## 4.0.0.2<a name="c4002"></a>
- Cache-Liste downloadbarer Bibliotheken wird bei Update bereinigt
- Update-Assistent wird bei Ausfhrung des Installationsassistenten unterdrckt

## 4.0.0.1<a name="c4001"></a>
- Prfung auf existierende Parent-Methode korrigiert

## 4.0.0.0<a name="c4000"></a>
- 4 Basisbibliotheken werden in einer Gesamtbibliothek zusammengefasst
- Prfung auf existierende Parent-Methoden prft nun auch in Modul-Erweiterungen (optional)

---

# ModCfg

## 3.10.3.0
- Bibliothek-Module werden nicht als "inaktiv" markiert, wenn sich Extensions ndern
- Parameter-Container korrigiert

## 3.10.2.1
- Metadaten korrigiert

## 3.10.2.0
- Parameter-Container eingefgt
- Kurzbeschreibungsfeld fr Profile gekrzt

## 3.10.1.0
- interne Strukturnderungen

## 3.10.0.2
- Modul-Meta-Refresh deaktiviert nicht die betroffenen Module
- Admin-Profilliste filtert nach Gruppen
- Profile um Kurzbeschreibungsfeld ergnzt
- Aktiv-Prfung fr Profile ist Admin-Liste korrigiert
- Methodenreichweite verndert (_d3getFolderTitle() -> public)
- Vermeiden von Notices

## 3.10.0.1
- Layoutfehler korrigiert

## 3.10.0.0
- Umstellung auf "automatische Installation"
- Seitennavigation enthlt Shop-Parameter (EE)

## 3.9.0.7
- "lokale Verwendung" der Lizenzschlssel korrigiert
- Verwendung der Revisionsnummer gegen Versionsnummer getauscht

## 3.9.0.6
- inkompatibler Templateaufruf bereinigt
- isAvailable-Check korrigiert

## 3.9.0.5
- Aktivierung korrigiert, wenn Admin unter SSL luft
- inaktive Listeneintrge werden in Admin gezeigt
- fehlendes pagenavigation-Template eingefgt

## 3.9.0.4
- Lizenzschlsselprfung korrigiert

## 3.9.0.3
- Verfgbarkeitsprfung prft auf korrekte Anzahl der Basis-Bibliothek-Eintrge
- Lizenzcache korrigiert
- "Eintrag duplizieren" speichert keine Einstellungen

## 3.9.0.2
- problematisches "on update current_timestamp" aus Struktur entfernt

## 3.9.0.1
- Fehler beim Speichern der Log-Einstellungen korrigiert

## 3.9.0.0
- Modulprofile eingefgt

## 3.8.0.0
- PHP 5.4 berprfung angepasst
- Fehlerbehandlung erweitert
- Erweiterbarkeit verbessert

## 3.7.0.1
- Feldvererbung korrigiert (Moduleinstellungen waren nicht in Sprache >0 abrufbar

## 3.7.0.0
- bersicht ber verfgbare (nicht installierte) Module eingefgt
- erweiterte Counter integriert

## 3.6.0.0
- Enterprise Edition: Rechte&Rollen auch fr D3-Module nutzbar

## 3.5.0.0
- Verwaltung weiterer Keysets integriert (Nutzung der Serials durch andere Partner)

## 3.3.0.0
- Lizenzaktivierung ber D3-Server aktiviert

## 3.2.0.0
- Template-Includes vereinheitlicht

## 3.1.0.0
- Aktivierungs-Assistent eingearbeitet

## 3.0.0.4
- Autoupdate korrigiert
- Smarty-Plugins in Modul-Verzeichnis verschoben

## 3.0.0.3
- Fehler in der ModCfg-Instanz-Verwaltung behoben

## 3.0.0.1
- Lizenzprfung fr lokale Installtionen korrigiert

---

# Install

## 2.6.1.0
- Fehlermeldung in Installation entfernt
- Ausfhrung in CLI stoppt Ausfhrung nicht
- UTF-DB-Inhalte werden vor Update konvertiert
- Installationsassistent prft auch in "setup"-Verzeichnis auf Install-Scripte
- Behandlung fr Erweiterung von ENUM-Feldern eingefgt

## 2.6.0.1
- verhindert weitere Meta-Refresh-Aktionen

## 2.6.0.0
- Bibliotheken verwenden "automatische Installation"
- Collation-Cache korrigiert
- Modul-Prfungen werden auf Versionsnummern anstatt Revisionsnummern durchgefhrt
- zeigt Hinweis, wenn Bibliotheken automatisch deaktiviert werden
- DB-Index-Typen korrigiert
- manueller Installationsstart setzt SkipFlag zurck

## 2.5.0.1
- PRIMARY INDEX Query angepasst

## 2.5.0.0
- Kollationshandling in automatische Installation eingefgt

## 2.4.1.0
- RegExp-Generator implementiert

## 2.4.0.1
- Gro-/Kleinschreibungsabhngiger Feld-Cache eingefgt
- genereller SQL- und CSV-Export eingefgt
- Installation bricht bei fehlenden Methoden ab
- simpleXML erweitert
- Datenverschiebefunktion fr automatische Installation eingefgt
- NULL-Handling bei automatischer Installation verbessert
- Admin-Navigation wird nach Installation aktualisiert

## 2.4.0.0
- weitere Methoden fr automatische Installation eingefgt
- PHP 5.4-berarbeitungen

## 2.3.0.2
- Verlinkung gendert
- zustzliche DB-Feld-Eigenschaften implementiert

## 2.3.0.0
- Performance-Optimierung
- Installation stellt Anzahl der Steps dar

## 2.2.0.3
- Bug in Rename-Job beseitigt

## 2.2.0.2
- Performance-Optimierung
- oxconfig-Methoden eingefgt

## 2.2.0.1
- fehlerhafte Query-Generierung bei Rename-Updates korrigiert

## 2.2.0.0
- Feature in Updateinstallation: Informationsseite

## 2.1.0.8
- Kommunikation zum Updateserver sehr langsam: behoben

## 2.1.0.7
- Lschen- und Entfern-Methoden eingefgt, Cache-Behandlung korrigiert

...

## 2.0.0.2
- ModCfg-Instanz-Handler angepat
- Demoshopmodus anzeigen lassen, wenn Funktionseinschrnkungen aktiv sind
- DB-Index-Installation eingefgt
- Lizenz-Aktivierung eingearbeitet

## 2.0.0.1
- falsche Weiterleitung bei automatischer Installation korrigiert

---

# Logging

## 2.4.1.0
- gruppierte Loglevel definiert
- Infomail liefert aufschlussreichere Daten
- Smarty-Fehler knnen geloged werden
- leere Logs werden nicht geschrieben
- Log-Textfeld auf Typ "Text" vergrert

## 2.4.0.0
- verwendet automatische Installation

## 2.3.0.2
- Transactionlog neue Methode hinzugefgt

## 2.3.0.1
- Error-Info-Mail korrigiert
- Transaction-Log nutzbar integriert

## 2.3.0.0
- Transaction-Log umgearbeitet

## 2.2.0.0
- Transaction-Log integriert
- Log speichert nun Profil-ID

## 2.1.0.1
- DB-Struktur fr bessere Performance verndert
- verwendet zentrale Export-Methoden
- lscht nur Log-Eintrge des gewhlten Mandanten
- Export ist nach Klassen und Sessions selektierbar
- Exceptions immer anzeigbar (optional)
- Exceptions werden in Log geschrieben

## 2.1.0.0
- Log-bersicht kann modulspezifisch in andere Erweiterungen integriert werden

## 2.0.0.6
- SQL-Export liefert alle Zeilen
- DB Struktur verndert (auto increment index)

## 2.0.0.5
- Log-Bit-Beschreibung gendert
- oxshopcontrol::start() bergibt komplette Parameterliste

## 2.0.0.4
- Tabellentyp eingefgt
- Level-Benennung gendert

...

## 2.0.0.1
- Testmodus implementiert
- DB-Indizes korrigiert

---

# ClearTmp

## 2.1.0.0
- verwendet "automatische Installation"

## 2.0.0.4
- Methodendeklaration korrigiert
- Templates angepasst

## 2.0.0.3
- Methodendeklaration korrigiert
- Frontend-Clear-TMP eingefgt, kann z.B. Views ohne Adminbereich aktualisieren

## 2.0.0.2
- verwendet registrierte Template anstelle von festen Pfadnamen

## 2.0.0.1
- ModCfg-Instanz-Handler aktualisiert
