<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_cfg_multilang_Imex extends d3_cfg_mod_main
{
    protected $_sThisTemplate = 'd3_cfg_multilang_imex.tpl';
    protected $_sExportDir = 'export';
    protected $_sModId = 'd3_multilang';
    protected $_sExportType = '';
    protected $_sImportType = '';
    protected $_sMimeType = '';
    protected $_aImportStatusMessage = array();
    protected $_sMenuItemTitle = 'd3mxmultilang';
    protected $_sMenuSubItemTitle = 'd3tbclmultilang_imex';
    public $aMessages = array();

    /**
     * @return string
     */
    public function render()
    {
        $this->setImportStatusMessages();

        $this->addTplParam('readonly', !$this->d3getSet()->isActive());

        $oLang = oxRegistry::getLang();
        $aLangList = oxRegistry::getConfig()->getRequestParameter('lang');
        if (isset($aLangList) && is_array($aLangList) && isset($aLangList['oxid'])) {
            $iLangNr = $aLangList['oxid'];
        } else {
            $iLangNr = 0;
        }
        $this->_aViewData['aImportLanguages'] = $oLang->getLanguageArray($iLangNr);

        return parent::render();
    }

    /**
     * @param $sMessage
     */
    public function addStatusMessage($sMessage)
    {
        $this->aMessages[] = $sMessage;
    }

    /**
     * @return bool
     */
    public function getStatusMessages()
    {
        return $this->aMessages;
    }

    /**
     * @param $sIdent
     *
     * @return mixed
     */
    public function getRequParam($sIdent)
    {
        return oxRegistry::getConfig()->getRequestParameter($sIdent);
    }

    public function setImportStatusMessages()
    {
        $this->_aImportStatusMessage = array(
            'csv'   => array(
                0   => 'D3_MULTILANG_NOT_SUCC',
                1   => 'D3_MULTILANG_SUCC_CSV',
            ),
            'xls'   => array(
                0   => 'D3_MULTILANG_NOT_SUCC',
                1   => 'D3_MULTILANG_SUCC_XLS',
            ),
            'oxid'   => array(
                0   => 'D3_MULTILANG_NOT_SUCC',
                1   => 'D3_MULTILANG_SUCC_OXID',
            ),
        );
    }

    public function export()
    {
        /** @var d3_translations $oTranslation */
        $oTranslation = oxNew('d3_translations');

        $this->_sExportType = oxRegistry::getConfig()->getRequestParameter('exporttype');

        if ($this->getExportType() == 'csv') {
            $oTranslation->exportCSV();
        } elseif ($this->getExportType() == 'xlsx') {
            $oTranslation->exportXLSX();
        } elseif ($this->getExportType() == 'xls') {
            $oTranslation->exportXLS();
        } elseif ($this->getExportType() == 'oxid') {
            $oTranslation->exportOxid();
        }
    }

    /**
     * @return string
     */
    public function getExportType()
    {
        return $this->_sExportType;
    }

    public function import()
    {
        /** @var d3_translations $oTranslation */
        $oTranslation = oxNew('d3_translations');

        if (!oxRegistry::getConfig()->isUtf()) {
            header("Content-Type: text/html; charset=UTF-8");
        }

        $this->_sImportType = oxRegistry::getConfig()->getRequestParameter('type');

        if ($this->getImportType() == 'csv') {
            $this->_sMimeType = $_FILES['file']['type']['csv'];
            $iImport = $oTranslation->importCSV();
            $this->addTplParam('clrTmp', $iImport);
            $this->addStatusMessage(
                sprintf(oxRegistry::getLang()->translateString('D3_MULTILANG_SUCC_CSV'), $iImport)
            );
        } elseif ($this->getImportType() == 'xls') {
            $this->_sMimeType = $_FILES['file']['type']['xls'];
            $iImport = $oTranslation->importXLS();
            $this->addTplParam('clrTmp', $iImport);
            $this->addStatusMessage(
                sprintf(oxRegistry::getLang()->translateString('D3_MULTILANG_SUCC_XLS'), $iImport)
            );
        } elseif ($this->getImportType() == 'oxid') {
            $this->_sMimeType = $_FILES['file']['type']['oxid'];
            $iImport = $oTranslation->importOxid();
            $this->addTplParam('clrTmp', $iImport);
            $this->addStatusMessage(
                sprintf(oxRegistry::getLang()->translateString('D3_MULTILANG_SUCC_OXID'), $iImport)
            );
        } elseif ($this->getImportType() == 'installed') {
            $iImport = $oTranslation->importInstalled();
            $this->addTplParam('clrTmp', $iImport);
            $this->addStatusMessage(
                sprintf(oxRegistry::getLang()->translateString('D3_MULTILANG_SUCC_INSTALLED'), $iImport)
            );
        }
    }

    /**
     * @return string
     */
    public function getImportType()
    {
        return $this->_sImportType;
    }

    /**
     * @return null|string
     */
    public function getMimeType()
    {
        if ($this->_sMimeType && $this->d3getSet()->getValue('blMultilang_OutputMimeType')) {
            return $this->_sMimeType;
        }

        return null;
    }

    public function clearLangCache()
    {
        /** @var d3clrtmp $oClrTmp */
        $oClrTmp = oxNew('d3clrtmp');

        if ($oClrTmp->clearLangCache()) {
            $this->addStatusMessage(oxRegistry::getLang()->translateString('D3_CFG_CLRTMP_SUCCESS'));
        }
    }

    /**
     * @return bool
     */
    public function hasExcelLib()
    {
        if (class_exists('PHPExcel')) {
            return false;
        }

        return false;
    }

    /**
     * @return d3_cfg_mod
     */
    public function d3getSet()
    {
        return d3_cfg_mod::get($this->_sModId);
    }
}
