<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3multilang_update extends d3install_updatebase
{
    public $sModKey = 'd3_multilang';
    public $sModName = 'bersetzungsassistent';
    public $sModVersion = '3.1.0.0';
    public $sModRevision = '121';
    public $sBaseConf = 'AkLMmdvdEQxRkdvL3Y2Z1dvT0txYy9RRFh0TnBnQWNNd0JGN3J0ZURNU3BxVDFFOXBVanR3ZzJZL2VBQ
2VhWko2bmlFbHZaN0k3d0VuREdOOThrbFE4WmxqeUdnMCtBMm5nakMzemlRT1hRYUI2MWJRSlZEME1SV
3NadWxJMkJJS1doOHFqMUgzeEJUdlhCb2dMank2VXpHSEkvQWpHbWF2TlpZdXR4Z0graGxqR0FCZUs2N
ER0MUx1YlpnWHp5UmFMN1BzUlEvZVIrL3dDTnJadmJaalVsRGlnZFJrbzExa1g1K1Q0Slhmb1JxMkZIS
EpHZjNkK0xoQm1iZnRDM2V0eFFyZTlxdDRTTFF2UzVldEcrUEFyQ0lBbCt0NktCQlMxejZOZ3lPeU44Z
GM9';
    public $sRequirements = '';
    public $sBaseValue = 'TyUzQTglM0ElMjJzdGRDbGFzcyUyMiUzQTQlM0ElN0JzJTNBMjglM0ElMjJkM19jZmdfbW9kX19hTGljZW5zZUluZm9NYWlsJTIyJTNCYSUzQTIlM0ElN0JzJTNBNDglM0ElMjJVTktOT1dOQ09ORktFWV9fNDc5MzYzODcwMmI2NzcxNWYxZGZiZmM4MzI0NjY5MTQlMjIlM0JzJTNBMTklM0ElMjIyMDEzLTEwLTE3JTIwMDklM0EzOSUzQTUyJTIyJTNCcyUzQTQyJTNBJTIyTk9MSUNLRVlfXzQ3OTM2Mzg3MDJiNjc3MTVmMWRmYmZjODMyNDY2OTE0JTIyJTNCcyUzQTE5JTNBJTIyMjAxMy0xMC0xNyUyMDA5JTNBNDElM0EyNyUyMiUzQiU3RHMlM0EzOCUzQSUyMmQzX2NmZ19tb2RfX2JsTXVsdGlsYW5nX091dHB1dE1pbWVUeXBlJTIyJTNCcyUzQTElM0ElMjIxJTIyJTNCcyUzQTMyJTNBJTIyZDNfY2ZnX21vZF9fc011bHRpbGFuZ19TZXBhcmF0b3IlMjIlM0JzJTNBMSUzQSUyMiU3QyUyMiUzQnMlM0E0MCUzQSUyMmQzX2NmZ19tb2RfX2JsTXVsdGlsYW5nX1NhdmVNaXNzaW5nSXRlbXMlMjIlM0JzJTNBMSUzQSUyMjElMjIlM0IlN0Q=';

    protected $_aUpdateMethods = array(
        array('check' => 'checkModCfgItemExist',
              'do'    => 'updateModCfgItemExist'),
        array('check' => 'checkRenameFields',
              'do'    => 'fixRenameFields'),
        array('check' => 'checkDeleteFields',
              'do'    => 'fixDeleteFields'),
        array('check' => 'checkTranslationTableExist',
              'do'    => 'updateTranslationTableExist'),
        array('check' => 'checkFields',
              'do'    => 'fixFields'),
        array('check' => 'checkIdentCollation',
              'do'    => 'fixIdentCollation'),
        array('check' => 'checkIndizes',
              'do'    => 'fixIndizes'),
        array('check' => 'checkFieldsCollation',
              'do'    => 'fixFieldsCollation'),
        array('check' => 'checkMultiLangDbItemsNotExist',
              'do'    => 'importMultiLangItems'),
        array('check' => 'hasUnregisteredFiles',
              'do'    => 'showUnregisteredFiles'),
        array('check' => 'checkModCfgSameRevision',
              'do'    => 'updateModCfgSameRevision'),
    );

    public $aFields = array(
        'OXID'        => array(
            'sTableName'  => 'd3_translations',
            'sFieldName'  => 'OXID',
            'sType'       => 'VARCHAR(100)',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'OXTEXT'        => array(
            'sTableName'  => 'd3_translations',
            'sFieldName'  => 'OXTEXT',
            'sType'       => 'TEXT',
            'blNull'      => false,
            'sDefault'    => false,
            'sComment'    => '',
            'sExtra'      => '',
            'blMultilang' => true,
            'sForceCollation'   => 'utf8_general_ci'
        ),
        'OXORIGINAL'        => array(
            'sTableName'  => 'd3_translations',
            'sFieldName'  => 'OXORIGINAL',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '0',
            'sComment'    => 'item is modified',
            'sExtra'      => '',
            'blMultilang' => true,
        ),
        'OXSTRING'        => array(
            'sTableName'  => 'd3_translations',
            'sFieldName'  => 'OXSTRING',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '1',
            'sComment'    => 'item ist string or serialized structure',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
        'OXADMIN'        => array(
            'sTableName'  => 'd3_translations',
            'sFieldName'  => 'OXADMIN',
            'sType'       => 'TINYINT(1)',
            'blNull'      => false,
            'sDefault'    => '0',
            'sComment'    => 'item is used in admin panel',
            'sExtra'      => '',
            'blMultilang' => false,
        ),
    );

    public $aIndizes = array(
        'OXID' => array(
            'sTableName' => 'd3_translations',
            'sType'      => 'PRIMARY KEY',
            'sName'      => 'OXID',
            'aFields'    => array(
                'OXID'   => 'OXID',
                'OXADMIN'   => 'OXADMIN',
            ),
        ),
    );

    public $aRenameFields = array(
        'OXID'        => array(
           'sTableName'  => 'd3_translations',
           'mOldFieldNames' => array('oxident', 'OXIDENT'), // is case sensitive
           'sFieldName'  => 'OXID',
           'blMultilang' => false,
        ),
        'OXTEXT_0'        => array(
           'sTableName'  => 'd3_translations',
           'mOldFieldNames' => array('oxtext', 'oxtext_0'), // is case sensitive
           'sFieldName'  => 'OXTEXT',
           'blMultilang' => false,
        ),
        'OXTEXT'        => array(
           'sTableName'  => 'd3_translations',
           'mOldFieldNames' => array('oxtext'), // is case sensitive
           'sFieldName'  => 'OXTEXT',
           'blMultilang' => true,
        ),
        'OXORIGINAL'        => array(
           'sTableName'  => 'd3_translations',
           'mOldFieldNames' => array('oxoriginal'), // is case sensitive
           'sFieldName'  => 'OXORIGINAL',
           'blMultilang' => false,
        ),
    );

    public $aDeleteFields = array(
        'OXISSET'        => array(
            'sTableName'  => 'd3_translations',
            'sFieldName'  => 'oxisset',
            'blMultilang' => false,
        ),
    );

    protected $_aRefreshMetaModuleIds = array('d3_multilang');

    /**
     * @return bool
     */
    public function checkModCfgItemExist()
    {
        $blRet = false;
        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxmodid'       => $this->sModKey,
                'oxnewrevision' => $this->sModRevision,
                'oxshopid'      => $oShop->getId(),
            );

            $blRet = $this->_checkTableItemNotExist('d3_cfg_mod', $aWhere);

            if ($blRet) {
                return $blRet;
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function updateModCfgItemExist()
    {
        $blRet = false;

        if ($this->checkModCfgItemExist()) {
            if (method_exists($this, 'setInitialExecMethod')) {
                $this->setInitialExecMethod(__METHOD__);
            }

            foreach ($this->getShopList() as $oShop) {
                /** @var $oShop oxshop */
                $aWhere = array(
                    'oxmodid'       => $this->sModKey,
                    'oxshopid'      => $oShop->getId(),
                    'oxnewrevision' => $this->sModRevision,
                );

                if ($this->_checkTableItemNotExist('d3_cfg_mod', $aWhere)) {
                    // update don't use this property
                    unset($aWhere['oxnewrevision']);

                    $aInsertFields = array(
                        'OXID'           => array (
                            'content'       => "md5('" . $this->sModKey . " " . $oShop->getId() . " de')",
                            'force_update'  => true,
                            'use_quote'     => false,
                        ),
                        'OXSHOPID'       => array (
                            'content'       => $oShop->getId(),
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXMODID'        => array (
                            'content'       => $this->sModKey,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXNAME'         => array (
                            'content'       => $this->sModName,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXACTIVE'       => array (
                            'content'       => "0",
                            'force_update'  => false,
                            'use_quote'     => false,
                        ),
                        'OXBASECONFIG'   => array (
                            'content'       => $this->sBaseConf,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXSERIAL'   => array (
                            'content'       => "",
                            'force_update'  => false,
                            'use_quote'     => true,
                        ),
                        'OXINSTALLDATE'  => array (
                            'content'       => "NOW()",
                            'force_update'  => true,
                            'use_quote'     => false,
                        ),
                        'OXVERSION'      => array (
                            'content'       => $this->sModVersion,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXSHOPVERSION'  => array (
                            'content'       => oxRegistry::getConfig()->getEdition(),
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXREQUIREMENTS' => array (
                            'content'       => $this->sRequirements,
                            'force_update'  => true,
                            'use_quote'     => true,
                        ),
                        'OXVALUE'        => array(
                            'content'       => $this->sBaseValue,
                            'force_update'  => false,
                            'use_quote'     => true,
                        ),
                        'OXNEWREVISION'  => array(
                            'content'       => $this->sModRevision,
                            'force_update'  => true,
                            'use_quote'     => true,
                        )
                    );

                    $this->setInitialExecMethod(__METHOD__);
                    $blRet  = $this->_updateTableItem2('d3_cfg_mod', $aInsertFields, $aWhere);
                }
            }
        }
        return $blRet;
    }

    /**
     * @return bool
     */
    public function checkTranslationTableExist()
    {
        return $this->_checkTableNotExist('d3_translations');
    }

    /**
     * @return bool
     */
    public function updateTranslationTableExist()
    {
        $blRet = false;
        if ($this->checkTranslationTableExist()) {
            $this->setInitialExecMethod(__METHOD__);
            $blRet  = $this->_addTable2('d3_translations', $this->aFields, $this->aIndizes, 'D3 multilang', 'MyISAM');
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function checkIdentCollation()
    {
        $sFieldCollation = $this->_getIdentCollation();

        $sPattern = '@.*_cs@';
        return false == preg_match($sPattern, $sFieldCollation);
    }

    /**
     * @return bool
     */
    public function fixIdentCollation()
    {
        $sFieldIdent = 'OXID';
        $sFieldCollation = $this->_getIdentCollation();
        $sPattern = '@(.*)_ci@';

        preg_match($sPattern, $sFieldCollation, $aMatches);
        $oDatabase = $this->_getDatabaseHandler();

        $sSelect = 'ALTER TABLE `'.$this->aFields[$sFieldIdent]['sTableName'].'` CHANGE `'.
            $this->aFields[$sFieldIdent]['sFieldName'].'` `'.$this->aFields[$sFieldIdent]['sFieldName'].'` '.
            $this->aFields[$sFieldIdent]['sType'].' CHARACTER SET '.$oDatabase->getBaseCharset().
            ' COLLATE '.$aMatches[1].'_cs NOT NULL;';

        $this->setActionLog(
            'SQL',
            $sSelect,
            $this->getInitialExecMethod(__METHOD__)
        );

        /** @var d3installdbcommon $oDbCommon */
        $oDbCommon = oxNew('d3installdbcommon', $this);
        $blRet = $oDbCommon->tableSqlExecute($sSelect, $this->aFields[$sFieldIdent]['sTableName'], false);

        return $blRet;
    }

    /**
     * @return string
     */
    protected function _getIdentCollation()
    {
        if ($this->getCacheHandler()->has(__METHOD__)) {
            return $this->getCacheHandler()->get(__METHOD__);
        }

        startProfile(__METHOD__);

        $myConfig = oxRegistry::getConfig();
        $sSelect = 'select c.COLLATION_NAME from INFORMATION_SCHEMA.tables t ' .
            'LEFT JOIN INFORMATION_SCHEMA.columns c ON t.TABLE_NAME = c.TABLE_NAME  ' .
            'where t.TABLE_SCHEMA = "' . $myConfig->getConfigParam('dbName') . '" ' .
            'and t.TABLE_NAME = "d3_translations" ' .
            'and c.TABLE_SCHEMA = "' . $myConfig->getConfigParam('dbName') . '" ' .
            'and c.COLUMN_NAME = "OXID" ' .
            ' LIMIT 1';

        $sCollation = oxDb::getDb(oxDb::FETCH_MODE_ASSOC)->getOne($sSelect);
        $this->getCacheHandler()->set(__METHOD__, $sCollation);

        stopProfile(__METHOD__);

        return $sCollation;
    }

    /**
     * @return bool
     */
    public function checkIndexRefreshMsg()
    {
        if (oxRegistry::getSession()->getVariable('checkIndexRefreshMsg')) {
            return true;
        }

        return false;
    }

    /**
     * @return bool
     */
    public function fixIndexRefreshMsg()
    {
        $blRet = true;

        if (oxRegistry::getSession()->getVariable('checkIndexRefreshMsg')) {
            oxRegistry::getSession()->setVariable('checkIndexRefreshMsg', false);
            $this->_confirmMessage('D3_EXTSEARCH_UPDATE_GENPHONETIC');
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function checkContentNoArtItemExist()
    {
        $blRet = false;
        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxloadid' => 'd3extsearch_noarticlefound',
                'oxshopid' => $oShop->getId(),
            );

            $blRet = $this->_checkTableItemNotExist('oxcontents', $aWhere);

            if ($blRet) {
                return $blRet;
            }
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function updateContentNoArtItemExist()
    {
        $blRet = false;

        foreach ($this->getShopList() as $oShop) {
            /** @var $oShop oxshop */
            $aWhere = array(
                'oxloadid' => 'd3extsearch_noarticlefound',
                'oxshopid' => $oShop->getId(),
            );

            if ($this->_checkTableItemNotExist('oxcontents', $aWhere)) {
                $aWhere = array();
                $aInsertFields = array(
                    array (
                        'fieldname'     => 'OXID',
                        'content'       => "md5('d3extsearch_noarticlefound " . $oShop->getId() . "')",
                        'force_update'  => true,
                        'use_quote'     => false,
                    ),
                    array (
                        'fieldname'     => 'OXLOADID',
                        'content'       => "d3extsearch_noarticlefound",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXSHOPID',
                        'content'       => $oShop->getId(),
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXSNIPPET',
                        'content'       => "1",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXTYPE',
                        'content'       => "0",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXACTIVE',
                        'content'       => "1",
                        'force_update'  => false,
                        'use_quote'     => true,
                        'use_multilang' => true,
                    ),
                    array (
                        'fieldname'     => 'OXPOSITION',
                        'content'       => "",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => $this->_getLangAbbrFieldName('oxcontents', 'OXTITLE', 'de'),
                        'content'       => "Leider wurden keine Artikel gefunden",
                        'force_update'  => false,
                        'use_quote'     => true,
                        'use_multilang' => true,
                    ),
                    array (
                        'fieldname'     => 'OXCONTENT',
                        'content'       => "<p>Versuchen Sie es mit einem anderen Suchbegriff, einer anderen Schreibweise oder anderen Filtern bitte noch einmal. </p><p>Erhalten Sie dennoch keine Ergebnisse, kontaktieren Sie uns bitte <a href=\"[{oxgetseourl ident=\$oViewConf->getSelfLink()|cat:\"cl=contact\"}]\">hier</a>.</p><br />",
                        'force_update'  => false,
                        'use_quote'     => true,
                        'use_multilang' => true,
                    ),
                    array (
                        'fieldname'     => $this->_getLangAbbrFieldName('oxcontents', 'OXTITLE', 'en'),
                        'content'       => "Sorry, no items were found.",
                        'force_update'  => false,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXCATID',
                        'content'       => "kgo83a794223bfd23cbb091d0a34019d",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                    array (
                        'fieldname'     => 'OXFOLDER',
                        'content'       => "CMSFOLDER_USERINFO",
                        'force_update'  => true,
                        'use_quote'     => true,
                    ),
                );

                $this->setInitialExecMethod(__METHOD__);
                $blRet  = $this->_updateTableItem2('oxcontents', $aInsertFields, $aWhere);

                if ($this->getStepByStepMode()) {
                    break;
                }
            }
        }

        return $blRet;
    }

    /**
     * @return bool true, if update is required
     */
    public function checkMultiLangDbItemsNotExist()
    {
        $blRet = false;

        // change this to your inividual check criterias
        $sSql  = "SELECT count(`oxid`) ";
        $sSql .= "FROM `d3_translations` WHERE 1;";

        if ($this->getDb()->getOne($sSql) == 0) {
            $blRet = true;
        }

        return $blRet;
    }

    /**
     * @return bool
     */
    public function importMultiLangItems()
    {
        $this->setInitialExecMethod(__METHOD__);

        if ($this->checkMultiLangDbItemsNotExist()) {
            if ($this->hasExecute()) {
                /** @var d3_translations $oTranslation */
                $oTranslation = oxNew('d3_translations');
                $iImport = $oTranslation->importInstalled();
                $this->setActionLog(
                    'MSG',
                    sprintf(oxRegistry::getLang()->translateString('D3_MULTILANG_INSTALL_IMPORTSUCC'), $iImport),
                    $this->getInitialExecMethod(__METHOD__)
                );
            } else {
                $this->setActionLog(
                    'MSG',
                    oxRegistry::getLang()->translateString('D3_MULTILANG_INSTALL_EXECIMPORT'),
                    $this->getInitialExecMethod(__METHOD__)
                );
            }
            $this->setUpdateBreak(true);
        }

        return true;
    }

    /**
     * @return bool
     */
    public function hasUnregisteredFiles()
    {
        return $this->_hasUnregisteredFiles('d3_multilang', array('blocks', 'd3FileRegister'));
    }

    /**
     * @return bool
     */
    public function showUnregisteredFiles()
    {
        return $this->_showUnregisteredFiles('d3_multilang', array('blocks', 'd3FileRegister'));
    }
}
