<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */
$aModule = array(
    'id'          => 'd3_multilang',
    'title'       => (class_exists('d3utils') ? d3utils::getInstance()->getD3Logo() : 'D&sup3;') . ' &Uuml;bersetzungsassistent',
    'description' => array(
        'de' => 'Verwalten Sie die Textbausteine des Shop bequem im Adminbereich',
        'en' => '',
    ),
    'thumbnail'   => 'picture.png',
    'version'     => '3.1.0.0',
    'author'      => 'D&sup3; Data Development (Inh.: Thomas Dartsch)',
    'email'       => 'support@shopmodule.com',
    'url'         => 'http://www.oxidmodule.com/',
    'extend'      => array(
        'oxlang'     => 'd3/d3multilang/modules/core/d3_oxlang_multilang',
        'd3cleartmp' => 'd3/d3multilang/modules/controllers/admin/d3cleartmp_multilang',
        'sysreq_main'=> 'd3/d3multilang/modules/controllers/admin/d3_sysreq_main_multilang',
        'navigation' => 'd3/d3multilang/modules/controllers/admin/d3_navigation_multilang',
        'oxsysrequirements' => 'd3/d3multilang/modules/core/d3_oxsysrequirements_multilang',
    ),
    'files'       => array(
        'd3_cfg_multilang'         => 'd3/d3multilang/controllers/admin/d3_cfg_multilang.php',
        'd3_cfg_multilang_imex'    => 'd3/d3multilang/controllers/admin/d3_cfg_multilang_imex.php',
        'd3_cfg_multilang_licence' => 'd3/d3multilang/controllers/admin/d3_cfg_multilang_licence.php',
        'd3_cfg_multilang_list'    => 'd3/d3multilang/controllers/admin/d3_cfg_multilang_list.php',
        'd3_cfg_multilang_main'    => 'd3/d3multilang/controllers/admin/d3_cfg_multilang_main.php',
        'd3_translations'          => 'd3/d3multilang/models/d3_translations.php',
        'd3multilang_update'       => 'd3/d3multilang/setup/d3multilang_update.php',
    ),
    'templates'   => array(
        'd3_cfg_multilang_imex.tpl' => 'd3/d3multilang/views/admin/tpl/d3_cfg_multilang_imex.tpl',
        'd3_cfg_multilang_main.tpl' => 'd3/d3multilang/views/admin/tpl/d3_cfg_multilang_main.tpl',
    ),
    'events'      => array(
        'onActivate' => 'd3install::checkUpdateStart',
    ),
    'settings'    => array(
    ),
    'blocks'      => array(
        array(
            'template' => 'd3cleartmp.tpl',
            'block'    => 'd3cleartmp_additional',
            'file'     => 'views/admin/blocks/d3cleartmp_multilang.tpl',
        ),
        array(
            'template' => 'd3cleartmp.tpl',
            'block'    => 'd3cleartmp_js_singleitems',
            'file'     => 'views/admin/blocks/d3cleartmp_multilang_js.tpl',
        ),
    ),
    'd3FileRegister'    => array(
        'd3/d3multilang/IntelliSenseHelper.php',
        'd3/d3multilang/metadata.php',
        'd3/d3multilang/views/admin/de/d3_multilang_lang.php',
        'd3/d3multilang/views/admin/en/d3_multilang_lang.php',
        'd3/d3multilang/views/admin/tpl/modcfg-pattern/oxid_lang_file.tpl',
    ),
);