<?php

/**
 * This Software is the property of Data Development and is protected
 * by copyright law - it is NOT Freeware.
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 * http://www.shopmodule.com
 *
 * @copyright (C) D3 Data Development (Inh. Thomas Dartsch)
 * @author    D3 Data Development - Daniel Seifert <support@shopmodule.com>
 * @link      http://www.oxidmodule.com
 */

class d3_cfg_multilang_main extends d3_cfg_mod_main
{
    protected $_sThisTemplate = 'd3_cfg_multilang_main.tpl';
    protected $_iListSize = 0;
    protected $_iCurrListPos = 0;
    protected $_oPageNavigation;
    protected $_sModId = 'd3_multilang';
    public $iAdminListSize = 20;
    public $sSearchText;
    public $sSearchType;
    public $sItemType;
    public $iLangsel_left;
    public $iLangsel_right;
    public $aLangSel = array();
    protected $_sMenuItemTitle = 'd3mxmultilang';
    protected $_sMenuSubItemTitle = 'd3tbclmultilang_translations';

    /**
     * @return string
     */
    public function render()
    {
        $sRet = parent::render();

        $this->addTplParam('readonly', !$this->d3getSet()->isActive());

        oxDb::getDb()->Execute("SET NAMES 'utf8'");

        /** @var d3_translations $oTranslation */
        $oTranslation = oxNew('d3_translations');
        $this->iAdminListSize = 20;
        $iLangOk = 0;

        $this->sSearchText = oxRegistry::getConfig()->getRequestParameter('searchtext');
        $this->sSearchType = oxRegistry::getConfig()->getRequestParameter('searchtype');
        $this->sItemType   = oxRegistry::getConfig()->getRequestParameter('itemtype');
        $this->addTplParam('sItemtype', $this->sItemType);

        if ($this->sSearchText) {
            $this->addTplParam('sSearchtext', $this->sSearchText);
            $this->addTplParam('sSearchtype', $this->sSearchType);
            $this->addTplParam('whereparam', "&amp;searchtext=" . $this->sSearchText);
        }

        if (oxRegistry::getSession()->getVariable('langsel_left') !== false
            && oxRegistry::getSession()->getVariable('langsel_left') != ''
        ) {
            $this->iLangsel_left = oxRegistry::getSession()->getVariable('langsel_left');
            $this->addTplParam('langsel_left', $this->iLangsel_left);
            $iLangOk++;
        } elseif ($this->iLangsel_left !== false && $this->iLangsel_left != '') {
            $this->addTplParam('langsel_left', $this->iLangsel_left);
            $iLangOk++;
        } else {
            $this->addTplParam('langsel_left', 'none');
        }

        if (oxRegistry::getSession()->getVariable('langsel_right') !== false
            && oxRegistry::getSession()->getVariable('langsel_right') != ''
        ) {
            $this->iLangsel_right = oxRegistry::getSession()->getVariable('langsel_right');
            $this->addTplParam('langsel_right', $this->iLangsel_right);
            $iLangOk++;
        } elseif ($this->iLangsel_right !== false && $this->iLangsel_right != '') {
            $this->addTplParam('langsel_right', $this->iLangsel_right);
            $iLangOk++;
        } else {
            $this->addTplParam('langsel_right', 'none');
        }

        // ToDo: Suche mit in Anzahl aufnehmen
        $oTranslation->setSearchFilter(
            $this->iLangsel_left,
            $this->iLangsel_right,
            $this->sSearchText,
            $this->sSearchType,
            $this->sItemType
        );
        $this->_iListSize = $oTranslation->getItemCount();

        /** @var d3pagenavigation _oPageNavigation */
        $this->_oPageNavigation = new d3pagenavigation();
        $this->_oPageNavigation->addUrlParam('searchtext', $this->sSearchText);
        $this->_oPageNavigation->addUrlParam('searchtype', $this->sSearchType);
        $this->_oPageNavigation->setItems($this->_iListSize, $this->iAdminListSize);
        $this->_iCurrListPos = $this->_oPageNavigation->getCurrentItem();

        $this->addTplParam('d3pagenavi', $this->_oPageNavigation);
        $this->addTplParam('iPage', $this->_oPageNavigation->getCurrentPage());
        $this->addTplParam('aLanguages', oxRegistry::getLang()->getlanguageArray());

        if ($iLangOk == 2) {
            $aTranslList = $oTranslation->getTranslationArray(
                false,
                true,
                true,
                $this->_iCurrListPos - 1,
                $this->iAdminListSize,
                $this->sSearchText
            );
            $aTranslations = array();

            if (is_array($aTranslList[$this->iLangsel_left]) && count($aTranslList[$this->iLangsel_left])) {
                foreach ($aTranslList[$this->iLangsel_left] as $sIdent => $sTranslation) {
                    $oTranslation = new stdClass;
                    $oTranslation->key = $aTranslList['OXID'][$sIdent];
                    $oTranslation->left = stripslashes(htmlentities($sTranslation, ENT_COMPAT, 'UTF-8'));
                    $oTranslation->right = stripslashes(
                        htmlentities($aTranslList[$this->iLangsel_right][$sIdent], ENT_COMPAT, 'UTF-8')
                    );
                    $oTranslation->original_left = $aTranslList['orig_'.$this->iLangsel_left][$sIdent];
                    $oTranslation->original_right = $aTranslList['orig_'.$this->iLangsel_right][$sIdent];
                    $aTranslations[$sIdent] = $oTranslation;
                }
            }

            $this->addTplParam('aTranslations', $aTranslations);
        }

        $this->addTplParam('listsize', $this->_iListSize);

        return $sRet;
    }

    public function languageselect()
    {
        $this->aLangSel = oxRegistry::getConfig()->getRequestParameter('langsel');

        if ($this->aLangSel['left'] !== false && $this->aLangSel['left'] != '') {
            oxRegistry::getSession()->setVariable('langsel_left', $this->aLangSel['left']);
        }

        if ($this->aLangSel['right'] !== false && $this->aLangSel['right'] != '') {
            oxRegistry::getSession()->setVariable('langsel_right', $this->aLangSel['right']);
        }
    }

    public function save()
    {
        $this->addTplParam('msg', 'success');

        /** @var d3_translations $oTranslation */
        $oTranslation = oxNew('d3_translations');
        $oTranslation->saveItemList();
    }

    public function clearLangCache()
    {
        /** @var d3clrtmp $oClrTmp */
        $oClrTmp = oxNew('d3clrtmp');

        if ($oClrTmp->clearLangCache()) {
            oxRegistry::get('oxUtilsView')->addErrorToDisplay('D3_CFG_CLRTMP_SUCCESS');
        }
    }

    public function deleteentry()
    {
        /** @var d3_translations $oTranslation */
        $oTranslation = oxNew('d3_translations');
        $sIdent = oxRegistry::getConfig()->getRequestParameter('deloxid');
        $oTranslation->delete($sIdent);
    }
}
