<?php

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */

$aModule = array(
    'id'           => 'd3heidelpay',
    'title'        => (class_exists('d3utils')?d3utils::getInstance()->getD3Logo():'D&sup3;').' Heidelpay',
    'description'  => array(
        'de'            => 'Heidelberger Payment GmbH bietet als Zahlungsinstitut H&auml;ndlern ein Zahlungssystem f&uuml;r alle g&auml;ngigen Zahlungsverfahren f&uuml;r die Payment Abwicklung im Internet.',
        'en'            => '',
    ),
    'thumbnail'    => 'picture.png',
    'version'      => '4.0.6.2',
    'author'       => 'D&sup3; Data Development, Inh. Thomas Dartsch',
    'email'        => 'support@shopmodule.com',
    'url'          => 'http://www.oxidmodule.com/',

    'events'      => array(
        'onActivate'   => 'd3install::checkUpdateStart',
    ),
    'extend' => array(
        'oxutilsview'      => 'd3/d3heidelpay/modules/core/d3_oxutilsview_heidelpay',
    	'order'            => 'd3/d3heidelpay/modules/controllers/d3_order_heidelpay',
    	'payment'          => 'd3/d3heidelpay/modules/controllers/d3_payment_heidelpay',
        'oxemail'          => 'd3/d3heidelpay/modules/models/d3_oxemail_heidelpay',
    	'oxinputvalidator' => 'd3/d3heidelpay/modules/models/d3_oxinputvalidator_heidelpay',
        'oxorder'          => 'd3/d3heidelpay/modules/models/d3_oxorder_heidelpay',
    	'oxpaymentgateway' => 'd3/d3heidelpay/modules/models/d3_oxpaymentgateway_heidelpay',
        'd3counter'        => 'd3/d3heidelpay/modules/models/d3_d3counter_heidelpay',
    ),
    'files' => array(
        'd3_hp_update'                                     => 'd3/d3heidelpay/models/d3_hp_update.php',
        'd3_heidelpaycfg'                                  => 'd3/d3heidelpay/controllers/admin/d3_heidelpaycfg.php',
        'd3_heidelpaycfg_main'                             => 'd3/d3heidelpay/controllers/admin/d3_heidelpaycfg_main.php',
        'd3_heidelpaycfg_list'                             => 'd3/d3heidelpay/controllers/admin/d3_heidelpaycfg_list.php',
        'd3_heidelpaycfg_support'                          => 'd3/d3heidelpay/controllers/admin/d3_heidelpaycfg_support.php',
        'd3hpprepaymentdata'                               => 'd3/d3heidelpay/models/d3hpprepaymentdata.php',
        'd3_hp_response'                                   => 'd3/d3heidelpay/models/d3_hp_response.php',
        'd3_hp_response_ot'                                => 'd3/d3heidelpay/models/d3_hp_response_ot.php',
        'd3_hp_bankaccount'                                => 'd3/d3heidelpay/models/d3_hp_bankaccount.php',
        'd3_d3heidelpay_controllers_admin_order_heidelpay' => 'd3/d3heidelpay/controllers/admin/order/heidelpay.php',
        'd3_d3heidelpay_models_factory'                    => 'd3/d3heidelpay/models/factory.php',
        'd3_d3heidelpay_models_request'                    => 'd3/d3heidelpay/models/request.php',
        'd3_d3heidelpay_models_response'                   => 'd3/d3heidelpay/models/response.php',
        'd3_d3heidelpay_models_communicator'               => 'd3/d3heidelpay/models/communicator.php',
        'd3_d3heidelpay_models_transactionlog_reader_heidelpay' => 'd3/d3heidelpay/models/transactionlog/reader/heidelpay.php',
    ),

    'templates' => array(
        'd3_heidelpaycfg_main.tpl'                             => 'd3/d3heidelpay/views/admin/tpl/d3_heidelpaycfg_main.tpl',
        'heidelpay_cc_input.tpl'                               => 'd3/d3heidelpay/views/tpl/page/checkout/heidelpay_cc_input.tpl',
        'heidelpay_order_3ds.tpl'                              => 'd3/d3heidelpay/views/tpl/page/checkout/heidelpay_order_3ds.tpl',
        'heidelpay_order_3ds_iframe.tpl'                       => 'd3/d3heidelpay/views/tpl/page/checkout/heidelpay_order_3ds_iframe.tpl',
        'payment_inc_afterstep4_info.tpl'                      => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_inc_afterstep4_info.tpl',
        'heidelpay_payment_inc_openform.tpl'                   => 'd3/d3heidelpay/views/tpl/page/checkout/inc/heidelpay_payment_inc_openform.tpl',
        'heidelpay_oxidpayment_inc_openform.tpl'               => 'd3/d3heidelpay/views/tpl/page/checkout/inc/heidelpay_oxidpayment_inc_openform.tpl',
        'payment_inc_storeduid.tpl'                            => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_inc_storeduid.tpl',
        'payment_heidelpaybillsafe.tpl'                        => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_heidelpaybillsafe.tpl',
        'payment_heidelpaycreditcard.tpl'                      => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_heidelpaycreditcard.tpl',
        'payment_heidelpaydebitcard.tpl'                       => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_heidelpaydebitcard.tpl',
        'payment_heidelpaydebitnote.tpl'                       => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_heidelpaydebitnote.tpl',
        'payment_heidelpayeps.tpl'                             => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_heidelpayeps.tpl',
        'payment_heidelpaygiropay.tpl'                         => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_heidelpaygiropay.tpl',
        'payment_heidelpayideal.tpl'                           => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_heidelpayideal.tpl',
        'payment_heidelpaysofort.tpl'                          => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_heidelpaysofort.tpl',
        'payment_heidelpaypaypal.tpl'                          => 'd3/d3heidelpay/views/tpl/page/checkout/inc/payment_heidelpaypaypal.tpl',
        'hp_prepayment_cust_html.tpl'                          => 'd3/d3heidelpay/views/tpl/email/html/hp_prepayment_cust_html.tpl',
        'hp_prepayment_cust_subj.tpl'                          => 'd3/d3heidelpay/views/tpl/email/html/hp_prepayment_cust_subj.tpl',
        'hp_prepayment_owner_html.tpl'                         => 'd3/d3heidelpay/views/tpl/email/html/hp_prepayment_owner_html.tpl',
        'hp_prepayment_owner_subj.tpl'                         => 'd3/d3heidelpay/views/tpl/email/html/hp_prepayment_owner_subj.tpl',
        'hp_prepayment_cust_plain.tpl'                         => 'd3/d3heidelpay/views/tpl/email/plain/hp_prepayment_cust_plain.tpl',
        'hp_prepayment_owner_plain.tpl'                        => 'd3/d3heidelpay/views/tpl/email/plain/hp_prepayment_owner_plain.tpl',
        'd3_d3heidelpay_controllers_admin_order_heidelpay.tpl' => 'd3/d3heidelpay/views/admin/tpl/d3_d3heidelpay_controllers_admin_order_heidelpay.tpl',
    ),

    'blocks' => array(
        array('template' => 'email/html/order_cust.tpl',    'block'=>'email_html_order_cust_paymentinfo',  'file'=>'/views/blocks/email_html_order_cust_paymentinfo.tpl'),
        array('template' => 'email/plain/order_cust.tpl',   'block'=>'email_plain_order_cust_paymentinfo', 'file'=>'/views/blocks/email_plain_order_cust_paymentinfo.tpl'),
        array('template' => 'page/checkout/payment.tpl',    'block'=>'checkout_payment_errors',            'file'=>'/views/blocks/checkout_payment_errors.tpl'),
        array('template' => 'page/checkout/payment.tpl',    'block'=>'checkout_payment_main',              'file'=>'/views/blocks/checkout_payment_main.tpl'),
        array('template' => 'page/checkout/payment.tpl',    'block'=>'change_payment',                     'file'=>'/views/blocks/change_payment.tpl'),
        array('template' => 'page/checkout/thankyou.tpl',   'block'=>'checkout_thankyou_info',             'file'=>'/views/blocks/checkout_thankyou_info.tpl'),
        array('template' => 'headitem.tpl',   'block'=>'admin_headitem_inccss',             'file'=>'/views/admin/blocks/admin_headitem_inccss.tpl'),
    ),
);
