<?php
/**
 * Class d3_order_heidelpay
 */
class d3_order_heidelpay extends d3_order_heidelpay_parent
{

    /**
     * Return-Klasse, die von der hp_resonse.php nach Aufruf order::execute() erhalten wurde (z.B. "thankyou")
     *
     * @var string
     */
    public $s3dsClassReturn;

    /**
     * Kontrollvariable fuer die Beendigung des 3DSecure-iFrames
     *
     * @var string
     */
    protected $_blIsHeidelpaySecureSuccess = false;

    protected $_sHeidelpaySecureTemplate = 'heidelpay_order_3ds.tpl';

    protected $_sHeidelpaySecureiFrameTemplate = 'heidelpay_order_3ds_iframe.tpl';

    /**
     * array of years
     * @var array
     */
    protected $_aCreditYears = null;

    /**
     * class constructor, register d3_d3heidelpay_models_settings_heidelpay
     */
    public function __construct()
    {
        $settings = oxNew('d3_d3heidelpay_models_settings_heidelpay', d3_cfg_mod::get('d3heidelpay'));
        oxRegistry::set('d3_d3heidelpay_models_settings_heidelpay', $settings);
        parent::__construct();
    }

    /**
     * try to execute order
     * Returns the following action
     *
     * @throws oxException
     * @return string Return-Wert fuer weiteren Klassen-Shopaufruf
     */
    public function execute()
    {
        if (false == d3_cfg_mod::get('d3heidelpay')->isActive()) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'module is inactive',
                'module is inactive'
            );

            return parent::execute();
        }

        try {
            /** @var d3_d3heidelpay_models_settings_heidelpay $settings */
            $settings       = oxRegistry::get('d3_d3heidelpay_models_settings_heidelpay');
            $oHeidelPayment = $settings->getPayment($this->getPayment());

            /** @var d3_d3heidelpay_controllers_order $controllerFacade */
            $controllerFacade = oxNew(
                'd3_d3heidelpay_controllers_order',
                oxRegistry::get('oxRegistry'),
                d3_cfg_mod::get('d3heidelpay'),
                oxNew('d3_d3heidelpay_models_factory', d3_cfg_mod::get('d3heidelpay'))
            );
            $mResult          = $controllerFacade->execute($oHeidelPayment);

            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'd3_d3heidelpay_controllers_order return value',
                print_r(var_export($mResult, true), true)
            );

            if (true === $mResult) {
                return parent::execute();
            }

            if (is_string($mResult)) {
                return $mResult;
            }

        } catch (d3_d3heidelpay_models_verify_exception_notloggedinexception $oEx) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'exception handling',
                get_class($oEx) . PHP_EOL . $oEx->getMessage() . PHP_EOL . $oEx->getTraceAsString()
            );

            return 'user';
        } catch (d3_d3heidelpay_models_verify_exception_checksessionchallengeexception $oEx) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'exception handling',
                get_class($oEx) . PHP_EOL . $oEx->getMessage() . PHP_EOL . $oEx->getTraceAsString()
            );

            return '';
        } catch (d3_d3heidelpay_models_verify_exception_agbnotacceptedexception $oEx) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'exception handling',
                get_class($oEx) . PHP_EOL . $oEx->getMessage() . PHP_EOL . $oEx->getTraceAsString()
            );
            $this->_blConfirmAGBError = 1;

            return '';
        } catch (d3_d3heidelpay_models_verify_exception_customerinformationnotacceptedexception $oEx) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'exception handling',
                get_class($oEx) . PHP_EOL . $oEx->getMessage() . PHP_EOL . $oEx->getTraceAsString()
            );
            $this->_blConfirmCustInfoError = 1;

            return '';
        } catch (d3_d3heidelpay_models_payment_exception_PaymentNotReferencedToHeidelpayException $oEx) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'exception handling',
                get_class($oEx) . PHP_EOL . $oEx->getMessage() . PHP_EOL . $oEx->getTraceAsString()
            );

            return parent::execute();
        } catch (d3_d3heidelpay_models_settings_exception_emptypaymentlistexception $oEx) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'exception handling',
                get_class($oEx) . PHP_EOL . $oEx->getMessage() . PHP_EOL . $oEx->getTraceAsString()
            );

            return parent::execute();
        }

        /** @var oxException $exception */
        $exception = oxNew('oxException', oxRegistry::getLang()->translateString('d3heidelpay_execute_error'));
        oxRegistry::get("oxUtilsView")->addErrorToDisplay($exception);

        d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
            d3log::INFO,
            __CLASS__,
            __FUNCTION__,
            __LINE__,
            'exception handling',
            get_class($exception) . PHP_EOL . $exception->getMessage() . PHP_EOL . $exception->getTraceAsString()
        );

        return '';
    }

    /**
     * {@inheritdoc}
     */
    protected function _getNextStep($mSuccess)
    {
        if (false == d3_cfg_mod::get('d3heidelpay')->isActive()) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'module is inactive',
                'module is inactive'
            );

            return parent::_getNextStep($mSuccess);
        }

        if ($mSuccess === 'Show3DSecureFrame') {
            if($this->d3CheckForMobileTheme() == true)
            {
                $sTemplateFor3DSecure = 'heidelpay_order_3ds_mobile.tpl';
            }
            else
            {
                $sTemplateFor3DSecure = 'heidelpay_order_3ds.tpl';
            }

            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'next step is Show3DSecureFrame',
                "set return: 'order?fnc=Show3DSecureFrame&heidelpaytemplate=".$sTemplateFor3DSecure."'"
            );

            return 'order?fnc=Show3DSecureFrame&heidelpaytemplate='.$sTemplateFor3DSecure;
        }

        $sReturn = parent::_getNextStep($mSuccess);

        /** @var d3_d3heidelpay_controllers_order $controllerFacade */
        $controllerFacade = oxNew(
            'd3_d3heidelpay_controllers_order',
            oxRegistry::get('oxRegistry'),
            d3_cfg_mod::get('d3heidelpay'),
            oxNew('d3_d3heidelpay_models_factory', d3_cfg_mod::get('d3heidelpay'))
        );

        $mNextStep = $controllerFacade->getNextOrderStep($sReturn, $mSuccess);

        d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
            d3log::INFO,
            __CLASS__,
            __FUNCTION__,
            __LINE__,
            'return value',
            "success: $sReturn, nextstep: " . var_export($mNextStep, true)

        );

        return $mNextStep;

    }

    /**
     * {@inheritdoc}
     */
    public function render()
    {
        $ret = parent::render();
        if (false === d3_cfg_mod::get('d3heidelpay')->isActive()) {
            return $ret;
        }

        $oHeidelpayViewConfig = oxNew(
            'd3_d3heidelpay_models_viewconfig',
            d3_cfg_mod::get('d3heidelpay'),
            oxRegistry::get('oxRegistry'),
            oxNew('d3_d3heidelpay_models_factory', d3_cfg_mod::get('d3heidelpay'))
        );

        $bl3dSecureFailed = (bool)oxRegistry::getConfig()->getRequestParameter('failed');
        $this->addTplParam('bl3dSecureFailed', $bl3dSecureFailed);

        $this->addTplParam('oHeidelpayViewConfig', $oHeidelpayViewConfig);
        $sHeidelpayTemplate = oxRegistry::getConfig()->getRequestParameter('heidelpaytemplate');

        if (false == empty($sHeidelpayTemplate)) {
            $this->_sThisTemplate = $sHeidelpayTemplate;
        }

        return $this->_sThisTemplate;
    }

    /**
     * Return route to payment if no d3 secure payment
     *
     * @return string partizielle rueckgabe der klasse
     */
    public function show3DSecureFrame()
    {
        if (false == d3_cfg_mod::get('d3heidelpay')->isActive()) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'module is inactive',
                'module is inactive'
            );

            return '';
        }

        /** @var d3_d3heidelpay_models_factory $oFactory */
        $oFactory = oxNew('d3_d3heidelpay_models_factory', d3_cfg_mod::get('d3heidelpay'));
        $sReturn  = '';

        // irgendein Wert nicht gesetzt oder falsch? Dann zurueck zu Schitt 3 !
        if (false == $oFactory->getSettings()->isSecurePayment(oxRegistry::get('oxRegistry'), $oFactory)) {
            $sReturn = 'payment?payerror=2';
        }

        d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
            d3log::INFO,
            __CLASS__,
            __FUNCTION__,
            __LINE__,
            'return value',
            var_export($sReturn, true)
        );

        return $sReturn;
    }

    /**
     * Returns 3d secure route if available.
     *
     * @return string
     */
    public function get3dsClassReturn()
    {
        if (false == d3_cfg_mod::get('d3heidelpay')->isActive()) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'module is inactive',
                'module is inactive'
            );

            return '';
        }

        if (false == $this->s3dsClassReturn) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'return value',
                'payment&payerror=-99'
            );

            return "payment&payerror=-99";
        }

        $sReturn = str_replace("?", "&", $this->s3dsClassReturn);
        d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
            d3log::INFO,
            __CLASS__,
            __FUNCTION__,
            __LINE__,
            'return value',
            var_export($sReturn, true)
        );

        return $sReturn;
    }

    /**
     * set 3d secure success
     */
    public function set3dsSuccess()
    {
        if (d3_cfg_mod::get('d3heidelpay')->isActive()) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                '3DS was successful',
                '3DS was successful'
            );
            $this->_blIsHeidelpaySecureSuccess = true;
            $this->s3dsClassReturn             = urldecode($this->getConfig()->getRequestParameter("action"));
        }
    }

    /**
     * Return true if 3d secure user input is successful
     *
     * @return bool
     */
    public function isHeidelpaySecureUserInputSuccess()
    {
        if (false == d3_cfg_mod::get('d3heidelpay')->isActive()) {
            $this->_blIsHeidelpaySecureSuccess = false;
        }

        d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
            d3log::INFO,
            __CLASS__,
            __FUNCTION__,
            __LINE__,
            'return value',
            print_r(var_export($this->_blIsHeidelpaySecureSuccess, true), true)
        );

        return $this->_blIsHeidelpaySecureSuccess;
    }

    /**
     * @return bool
     */
    public function d3CheckForMobileTheme()
    {
        $blIsMobile = false;
        if ( class_exists('oeThemeSwitcherThemeManager') == true) {
            /** @var oeThemeSwitcherThemeManager $oThemeManager */
            $oThemeManager = new oeThemeSwitcherThemeManager();
            $blIsMobile = $oThemeManager->isMobileThemeRequested();
        }
        return $blIsMobile;
    }

    /**
     * Template variable getter. Returns array of years for credit cards
     *
     * @return array
     */
    public function getCreditYears()
    {
        if ( $this->_aCreditYears === null ) {
            $this->_aCreditYears = false;

            $this->_aCreditYears = range( date('Y'), date('Y') + 10 );
        }
        return $this->_aCreditYears;
    }
}
