<?php

if (isset($_POST['response']) && strlen($_POST['response'])) {
    // eine 3DS Rueckgabe?
    $sXmlString                   = urldecode($_POST['response']);
    $aSessionIdParts              = explode('SessionID', $sXmlString);
    $sSessionId                   = str_replace(array('>', '</'), '', $aSessionIdParts[1]);
    $_POST['FRONTEND_SESSIONID'] = $sSessionId;
}

/**
 * Die Variable "FRONTEND_SESSION_ID" wurde von uns an den HP-Server uebergeben werden und wird 1:1 wieder zurueck gegeben.
 * Wir uebergeben dort folgende Struktur "90697a6c4f5f06ad35a9aa8c6b81d0de__@@step3__@@0__@@abc__@@xyz"
 * Wert-0 ist die Session-ID, die wir per force_sid an das System uebergeben muessen
 * Wert-1 kann "step3", "step4" "3dsframe" sein. Damit wissen wir, wo die Daten eingegeben wurden und in welcher Form die Rueckgabedaten vorliegen (POST oder XML)
 * Wert-2 beinhaltet die language ID
 * Wert-3 beinhaltet den rtoken
 * Wert-4 beinhaltet den stoken
 */

if (isset($_POST['FRONTEND_SESSIONID'])) {
    $aTmp                              = explode("__@@", $_POST['FRONTEND_SESSIONID']);
    $_POST['force_sid']                = $aTmp[0];
    $_POST['heidelpay_input_position'] = $aTmp[1];
    $_POST['language']                 = $_POST['lang'] = (int)$aTmp[2];
    $_POST['rtoken']                   = $aTmp[3];
    $_POST['stoken']                   = $aTmp[4];
    $_POST['shp']                      = $aTmp[5];
}

/**
 * Returns shop base path.
 *
 * @return string
 */
function getShopBasePath()
{
    return dirname(__FILE__) . '/../../../../';
}

require_once getShopBasePath() . "/bootstrap.php";

d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
    d3log::INFO,
    basename(__FILE__),
    'none',
    __LINE__,
    basename(__FILE__)." got requested",
    print_r($_POST, true)
);

/** @var d3_hp_response $oResponse */
$oResponse = oxNew('d3_hp_response');
$sReturn   = $oResponse->init();

d3_cfg_mod::get('d3heidelpay')->d3getLog()->Log(
    d3log::INFO,
    basename(__FILE__),
    'none',
    __LINE__,
    basename(__FILE__)." return value",
    $sReturn . PHP_EOL . $oResponse->getRedirectUrl()
);

if ($sReturn === d3_hp_response::REDIRECT) {
    header("HTTP/1.1 200 OK");
    header("Location: " . $oResponse->getRedirectUrl());
    header("Connection: close");
} else {
    echo $sReturn;
}

oxRegistry::getConfig()->pageClose();
