<?php

/**
 * Metadata version
 */
$sMetadataVersion = '1.1';

/**
 * Module information
 */

$aModule = array(
    'id'          => 'd3heidelpay',
    'title'       => (class_exists('d3utils') ? d3utils::getInstance()->getD3Logo() : 'D&sup3;') . ' Heidelpay',
    'description' => array(
        'de' => 'Heidelberger Payment GmbH bietet als Zahlungsinstitut H&auml;ndlern ein Zahlungssystem f&uuml;r alle g&auml;ngigen Zahlungsverfahren f&uuml;r die Payment Abwicklung im Internet.',
        'en' => '',
    ),
    'thumbnail'   => 'picture.png',
    'version'     => '5.2.0.1',
    'author'      => 'D&sup3; Data Development, Inh. Thomas Dartsch',
    'email'       => 'support@shopmodule.com',
    'url'         => 'http://www.oxidmodule.com/',
    'events'      => array(
        'onActivate' => 'd3install::checkUpdateStart',
    ),
    'extend'      => array(
        'oxemail'          => 'd3/d3heidelpay/modules/core/d3_oxemail_heidelpay',
        'oxutilsview'      => 'd3/d3heidelpay/modules/core/d3_oxutilsview_heidelpay',
        'order'            => 'd3/d3heidelpay/modules/application/controllers/d3_order_heidelpay',
        'payment'          => 'd3/d3heidelpay/modules/application/controllers/d3_payment_heidelpay',
        'thankyou'         => 'd3/d3heidelpay/modules/application/controllers/d3_thankyou_heidelpay',
        'oxinputvalidator' => 'd3/d3heidelpay/modules/application/models/d3_oxinputvalidator_heidelpay',
        'oxorder'          => 'd3/d3heidelpay/modules/application/models/d3_oxorder_heidelpay',
        'oxpaymentgateway' => 'd3/d3heidelpay/modules/application/models/d3_oxpaymentgateway_heidelpay',
        'd3counter'        => 'd3/d3heidelpay/modules/application/models/d3_d3counter_heidelpay',
        'oxbasketitem'     => 'd3/d3heidelpay/modules/application/models/d3_oxbasketitem_heidelpay',
    ),
    'files'       => array(
        'd3heidelpay_update'                                                                     => 'd3/d3heidelpay/setup/d3heidelpay_update.php',
        'd3_d3heidelpay_controllers_admin_base'                                                  => 'd3/d3heidelpay/controllers/admin/base.php',
        'd3_d3heidelpay_controllers_admin_settings'                                              => 'd3/d3heidelpay/controllers/admin/settings.php',
        'd3_d3heidelpay_controllers_admin_list'                                                  => 'd3/d3heidelpay/controllers/admin/list.php',
        'd3_d3heidelpay_controllers_admin_loglist'                                               => 'd3/d3heidelpay/controllers/admin/loglist.php',
        'd3_d3heidelpay_controllers_admin_log'                                                   => 'd3/d3heidelpay/controllers/admin/log.php',
        'd3_d3heidelpay_controllers_admin_support'                                               => 'd3/d3heidelpay/controllers/admin/support.php',
        'd3hpprepaymentdata'                                                                     => 'd3/d3heidelpay/models/d3hpprepaymentdata.php',
        'd3_hp_response'                                                                         => 'd3/d3heidelpay/models/d3_hp_response.php',
        'd3_hp_bankaccount'                                                                      => 'd3/d3heidelpay/models/d3_hp_bankaccount.php',
        'd3_d3heidelpay_controllers_order'                                                       => 'd3/d3heidelpay/controllers/order.php',
        'd3_d3heidelpay_controllers_admin_order_heidelpay'                                       => 'd3/d3heidelpay/controllers/admin/order/heidelpay.php',
        'd3_d3heidelpay_models_factory'                                                          => 'd3/d3heidelpay/models/factory.php',
        'd3_d3heidelpay_models_request'                                                          => 'd3/d3heidelpay/models/request.php',
        'd3_d3heidelpay_models_response'                                                         => 'd3/d3heidelpay/models/response.php',
        'd3_d3heidelpay_models_communicator'                                                     => 'd3/d3heidelpay/models/communicator.php',
        'd3_d3heidelpay_models_transactionlog_reader_heidelpay'                                  => 'd3/d3heidelpay/models/transactionlog/reader/heidelpay.php',
        'd3_d3heidelpay_models_verify_ordercontext'                                              => 'd3/d3heidelpay/models/verify/ordercontext.php',
        'd3_d3heidelpay_models_verify_exception_notloggedinexception'                            => 'd3/d3heidelpay/models/verify/exception/notloggedinexception.php',
        'd3_d3heidelpay_models_request_pattern_abstract'                                         => 'd3/d3heidelpay/models/request/pattern/abstract.php',
        'd3_d3heidelpay_models_request_pattern_onlinetransfer'                                   => 'd3/d3heidelpay/models/request/pattern/onlinetransfer.php',
        'd3_d3heidelpay_models_request_pattern_directdebit'                                      => 'd3/d3heidelpay/models/request/pattern/directdebit.php',
        'd3_d3heidelpay_models_request_pattern_debitcard'                                        => 'd3/d3heidelpay/models/request/pattern/debitcard.php',
        'd3_d3heidelpay_models_request_pattern_creditcard'                                       => 'd3/d3heidelpay/models/request/pattern/creditcard.php',
        'd3_d3heidelpay_models_request_pattern_prepayment'                                       => 'd3/d3heidelpay/models/request/pattern/prepayment.php',
        'd3_d3heidelpay_models_request_pattern_hip'                                              => 'd3/d3heidelpay/models/request/pattern/hip.php',
        'd3_d3heidelpay_models_request_pattern_bankaccountcheck'                                 => 'd3/d3heidelpay/models/request/pattern/bankaccountcheck.php',
        'd3_d3heidelpay_models_payment_abstract'                                                 => 'd3/d3heidelpay/models/payment/abstract.php',
        'd3_d3heidelpay_models_payment_creditcard'                                               => 'd3/d3heidelpay/models/payment/creditcard.php',
        'd3_d3heidelpay_models_payment_debitcard'                                                => 'd3/d3heidelpay/models/payment/debitcard.php',
        'd3_d3heidelpay_models_payment_directdebit'                                              => 'd3/d3heidelpay/models/payment/directdebit.php',
        //        'd3_d3heidelpay_models_payment_postfinance'                                              => 'd3/d3heidelpay/models/payment/postfinance.php',
        'd3_d3heidelpay_models_payment_billsafe'                                                 => 'd3/d3heidelpay/models/payment/billsafe.php',
        'd3_d3heidelpay_models_payment_prepayment'                                               => 'd3/d3heidelpay/models/payment/prepayment.php',
        'd3_d3heidelpay_models_payment_sofortueberweisung'                                       => 'd3/d3heidelpay/models/payment/sofortueberweisung.php',
        'd3_d3heidelpay_models_payment_przelewy24'                                               => 'd3/d3heidelpay/models/payment/przelewy24.php',
        'd3_d3heidelpay_models_payment_ideal'                                                    => 'd3/d3heidelpay/models/payment/ideal.php',
        'd3_d3heidelpay_models_payment_giropay'                                                  => 'd3/d3heidelpay/models/payment/giropay.php',
        'd3_d3heidelpay_models_payment_eps'                                                      => 'd3/d3heidelpay/models/payment/eps.php',
        'd3_d3heidelpay_models_payment_invoice_secured'                                          => 'd3/d3heidelpay/models/payment/invoice/secured.php',
        'd3_d3heidelpay_models_payment_invoice_unsecured'                                        => 'd3/d3heidelpay/models/payment/invoice/unsecured.php',
        'd3_d3heidelpay_models_payment_paypal'                                                   => 'd3/d3heidelpay/models/payment/paypal.php',
        'd3_d3heidelpay_models_payment_exception_paymentnotreferencedtoheidelpayexception'       => 'd3/d3heidelpay/models/payment/exception/paymentnotreferencedtoheidelpayexception.php',
        'd3_d3heidelpay_models_request_exception_noorderexception'                               => 'd3/d3heidelpay/models/request/exception/noorderexception.php',
        'd3_d3heidelpay_models_request_exception_notransactionuniqueid'                          => 'd3/d3heidelpay/models/request/exception/notransactionuniqueid.php',
        'd3_d3heidelpay_models_request_exception_nobasketexception'                              => 'd3/d3heidelpay/models/request/exception/nobasketexception.php',
        'd3_d3heidelpay_models_request_exception_nopaymentoptionexception'                       => 'd3/d3heidelpay/models/request/exception/nopaymentoptionexception.php',
        'd3_d3heidelpay_models_request_exception_nopaymentmethodexception'                       => 'd3/d3heidelpay/models/request/exception/nopaymentmethodexception.php',
        'd3_d3heidelpay_models_request_exception_invalidtagnameexception'                        => 'd3/d3heidelpay/models/request/exception/invalidtagnameexception.php',
        'd3_d3heidelpay_models_request_exception_invalidheidelpaydataexception'                  => 'd3/d3heidelpay/models/request/exception/invalidheidelpaydataexception.php',
        'd3_d3heidelpay_models_request_exception_unknownheidelpayonlinetransferpaymentexception' => 'd3/d3heidelpay/models/request/exception/unknownheidelpayonlinetransferpaymentexception.php',
        'd3_d3heidelpay_models_request_xml'                                                      => 'd3/d3heidelpay/models/request/xml.php',
        'd3_d3heidelpay_models_settings_exception_emptypaymentlistexception'                     => 'd3/d3heidelpay/models/settings/exception/emptypaymentlistexception.php',
        'd3_d3heidelpay_models_settings_exception_emptysecuritysenderexception'                  => 'd3/d3heidelpay/models/settings/exception/emptysecuritysenderexception.php',
        'd3_d3heidelpay_models_settings_exception_emptyusernameexception'                        => 'd3/d3heidelpay/models/settings/exception/emptyusernameexception.php',
        'd3_d3heidelpay_models_settings_exception_emptypasswordexception'                        => 'd3/d3heidelpay/models/settings/exception/emptypasswordexception.php',
        'd3_d3heidelpay_models_verify_exception_checksessionchallengeexception'                  => 'd3/d3heidelpay/models/verify/exception/checksessionchallengeexception.php',
        'd3_d3heidelpay_models_verify_exception_agbnotacceptedexception'                         => 'd3/d3heidelpay/models/verify/exception/agbnotacceptedexception.php',
        'd3_d3heidelpay_models_verify_exception_customerinformationnotacceptedexception'         => 'd3/d3heidelpay/models/verify/exception/customerinformationnotacceptedexception.php',
        'd3_d3heidelpay_models_verify_paymentsuccess'                                            => 'd3/d3heidelpay/models/verify/paymentsuccess.php',
        'd3_d3heidelpay_models_verify_abstract'                                                  => 'd3/d3heidelpay/models/verify/abstract.php',
        'd3_d3heidelpay_models_verify_input'                                                     => 'd3/d3heidelpay/models/verify/input.php',
        'd3_d3heidelpay_models_settings_heidelpay'                                               => 'd3/d3heidelpay/models/settings/heidelpay.php',
        'd3_d3heidelpay_models_viewconfig'                                                       => 'd3/d3heidelpay/models/viewconfig.php',
        'd3_d3heidelpay_controllers_paymentgateway'                                              => 'd3/d3heidelpay/controllers/paymentgateway.php',
        'd3_d3heidelpay_models_response_parser'                                                  => 'd3/d3heidelpay/models/response/parser.php',
        'd3_d3heidelpay_models_actions_abstract'                                                 => 'd3/d3heidelpay/models/actions/abstract.php',
        'd3_d3heidelpay_models_actions_refund'                                                   => 'd3/d3heidelpay/models/actions/refund.php',
        'd3_d3heidelpay_models_actions_rebill'                                                   => 'd3/d3heidelpay/models/actions/rebill.php',
        'd3_d3heidelpay_models_actions_capture'                                                  => 'd3/d3heidelpay/models/actions/capture.php',
        'd3_d3heidelpay_models_actions_chargeback'                                               => 'd3/d3heidelpay/models/actions/chargeback.php',
        'd3_d3heidelpay_models_actions_preauthorization'                                         => 'd3/d3heidelpay/models/actions/preauthorization.php',
        'd3_d3heidelpay_models_actions_debit'                                                    => 'd3/d3heidelpay/models/actions/debit.php',
        'ngw'                                                                                    => 'd3/d3heidelpay/models/ngw.php',
        'd3_d3heidelpay_models_redirect'                                                         => 'd3/d3heidelpay/models/redirect.php',
        'd3_d3heidelpay_models_payment_exception_unknownredirectparameterexception'              => 'd3/d3heidelpay/models/payment/exception/unknownredirectparameterexception.php',
        'd3_d3heidelpay_models_containers_skeleton'                                              => 'd3/d3heidelpay/models/containers/skeleton.php',
        'd3_d3heidelpay_models_generators_body'                                                  => 'd3/d3heidelpay/models/generators/body.php',
        'd3_d3heidelpay_models_containers_parameter'                                             => 'd3/d3heidelpay/models/containers/parameter.php',
        'd3_d3heidelpay_controllers_paymentcollector'                                            => 'd3/d3heidelpay/controllers/paymentcollector.php',
        'd3_d3heidelpay_models_request_pattern_onlinetransfercheck'                              => 'd3/d3heidelpay/models/request/pattern/onlinetransfercheck.php',
    ),
    'templates'   => array(
        #admin
        'd3_d3heidelpay_controllers_admin_settings.tpl'        => 'd3/d3heidelpay/views/admin/tpl/d3_d3heidelpay_controllers_admin_settings.tpl',
        'd3_d3heidelpay_controllers_admin_order_heidelpay.tpl' => 'd3/d3heidelpay/views/admin/tpl/d3_d3heidelpay_controllers_admin_order_heidelpay.tpl',
        // allgemeine Templates
        'payment_heidelpay_img.tpl'                            => 'd3/d3heidelpay/views/tpl/payment_heidelpay_img.tpl',
        ##azure-theme
        'heidelpay_cc_input.tpl'                               => 'd3/d3heidelpay/views/azure/tpl/page/checkout/heidelpay_cc_input.tpl',
        'heidelpay_order_3ds.tpl'                              => 'd3/d3heidelpay/views/azure/tpl/page/checkout/heidelpay_order_3ds.tpl',
        'heidelpay_order_3ds_iframe.tpl'                       => 'd3/d3heidelpay/views/azure/tpl/page/checkout/heidelpay_order_3ds_iframe.tpl',
        'payment_heidelpaycards.tpl'                           => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_heidelpaycards.tpl',
        'payment_inc_storeduid.tpl'                            => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_inc_storeduid.tpl',
        'payment_heidelpaybillsafe.tpl'                        => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_heidelpaybillsafe.tpl',
        'payment_heidelpaydebitnote.tpl'                       => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_heidelpaydebitnote.tpl',
        'payment_heidelpayeps.tpl'                             => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_heidelpayeps.tpl',
        'payment_heidelpaygiropay.tpl'                         => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_heidelpaygiropay.tpl',
        'payment_heidelpayideal.tpl'                           => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_heidelpayideal.tpl',
        'payment_heidelpaysofort.tpl'                          => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_heidelpaysofort.tpl',
        //        'payment_heidelpaypostfinance.tpl'                     => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_heidelpaypostfinance.tpl',
        'payment_heidelpaypaypal.tpl'                          => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_heidelpaypaypal.tpl',
        'payment_heidelpayprzelewy24.tpl'                      => 'd3/d3heidelpay/views/azure/tpl/page/checkout/inc/payment_heidelpayprzelewy24.tpl',
        'heidelpay_redirect_postformular.tpl'                  => 'd3/d3heidelpay/views/azure/tpl/page/checkout/heidelpay_redirect_postformular.tpl',
        'heidelpay_order_iframe.tpl'                           => 'd3/d3heidelpay/views/azure/tpl/page/checkout/heidelpay_order_iframe.tpl',
        'hp_prepayment_cust_html.tpl'                          => 'd3/d3heidelpay/views/azure/tpl/email/html/hp_prepayment_cust_html.tpl',
        'hp_prepayment_cust_subj.tpl'                          => 'd3/d3heidelpay/views/azure/tpl/email/html/hp_prepayment_cust_subj.tpl',
        'hp_prepayment_owner_html.tpl'                         => 'd3/d3heidelpay/views/azure/tpl/email/html/hp_prepayment_owner_html.tpl',
        'hp_prepayment_owner_subj.tpl'                         => 'd3/d3heidelpay/views/azure/tpl/email/html/hp_prepayment_owner_subj.tpl',
        'hp_prepayment_cust_plain.tpl'                         => 'd3/d3heidelpay/views/azure/tpl/email/plain/hp_prepayment_cust_plain.tpl',
        'hp_prepayment_owner_plain.tpl'                        => 'd3/d3heidelpay/views/azure/tpl/email/plain/hp_prepayment_owner_plain.tpl',
        ##mobile-theme
        'heidelpay_cc_input_mobile.tpl'                        => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/heidelpay_cc_input.tpl',
        'heidelpay_order_3ds_mobile.tpl'                       => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/heidelpay_order_3ds.tpl',
        'heidelpay_order_3ds_iframe_mobile.tpl'                => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/heidelpay_order_3ds_iframe.tpl',
        'payment_inc_storeduid_mobile.tpl'                     => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_inc_storeduid.tpl',
        'payment_heidelpaycards_mobile.tpl'                    => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_heidelpaycards.tpl',
        'payment_heidelpaysofort_mobile.tpl'                   => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_heidelpaysofort.tpl',
        'payment_heidelpaydebitnote_mobile.tpl'                => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_heidelpaydebitnote.tpl',
        'payment_heidelpayeps_mobile.tpl'                      => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_heidelpayeps.tpl',
        'payment_heidelpaygiropay_mobile.tpl'                  => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_heidelpaygiropay.tpl',
        'payment_heidelpayideal_mobile.tpl'                    => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_heidelpayideal.tpl',
        'payment_heidelpaybillsafe_mobile.tpl'                 => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_heidelpaybillsafe.tpl',
        'payment_heidelpaypaypal_mobile.tpl'                   => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_heidelpaypaypal.tpl',
        'payment_heidelpayprzelewy24_mobile.tpl'               => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_heidelpayprzelewy24.tpl',
        //        'payment_heidelpaypostfinance_mobile.tpl'        => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/inc/payment_heidelpaypostfinance.tpl',
        'heidelpay_order_iframe_mobile.tpl'                    => 'd3/d3heidelpay/views/mobile/tpl/page/checkout/heidelpay_order_iframe.tpl',

    ),
    'blocks'      => array(
        ##Admin
        array(
            'template' => 'headitem.tpl',
            'block'    => 'admin_headitem_inccss',
            'file'     => '/views/blocks/admin_headitem_inccss.tpl'
        ),

        #### azure
        array(
            'template' => 'page/checkout/payment.tpl',
            'block'    => 'change_payment',
            'file'     => '/views/blocks/change_payment.tpl'
        ),
        array(
            'template' => 'page/checkout/payment.tpl',
            'block'    => 'select_payment',
            'file'     => '/views/blocks/select_payment.tpl'
        ),

        ##mobile
        array(
            'template' => 'layout/base.tpl',
            'block'    => 'base_style',
            'file'     => '/views/blocks/base_style.tpl'
        ),
        array(
            'template' => 'page/checkout/payment.tpl',
            'block'    => 'mb_select_payment',
            'file'     => '/views/blocks/mb_select_payment.tpl'
        ),
        array(
            'template' => 'page/checkout/payment.tpl',
            'block'    => 'mb_select_payment_list',
            'file'     => '/views/blocks/mb_select_payment_list.tpl'
        ),

        ##azure+mobile
        array(
            'template' => 'email/html/order_cust.tpl',
            'block'    => 'email_html_order_cust_paymentinfo',
            'file'     => '/views/blocks/email_html_order_cust_paymentinfo.tpl'
        ),
        array(
            'template' => 'email/plain/order_cust.tpl',
            'block'    => 'email_plain_order_cust_paymentinfo',
            'file'     => '/views/blocks/email_plain_order_cust_paymentinfo.tpl'
        ),
        array(
            'template' => 'page/checkout/thankyou.tpl',
            'block'    => 'checkout_thankyou_info',
            'file'     => '/views/blocks/checkout_thankyou_info.tpl'
        ),
        array(
            'template' => 'page/checkout/payment.tpl',
            'block'    => 'checkout_payment_errors',
            'file'     => '/views/blocks/checkout_payment_errors.tpl'
        ),
    ),
);
