<?php

/**
 * class d3_payment_heidelpay
 */
class d3_payment_heidelpay extends d3_payment_heidelpay_parent
{

    /**
     * Bool-Wert fuer das Handling von vorhandenen Kreditkarten-Kunden-Registrierungsdaten in Schritt3
     *
     * @var bool
     */
    protected $sHeidelpayFieldsForPayment;

    protected $_sCheckedProductId;

    /**
     * Initiate and register module classes
     * intitiate reference number
     * reset payment success
     *
     * @return void
     */
    public function init()
    {
        parent::init();

        if (false == d3_cfg_mod::get('d3heidelpay')->isActive()) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'module is inactive',
                'module is inactive'
            );

            return;
        }

        $settings = oxNew('d3_d3heidelpay_models_settings_heidelpay', d3_cfg_mod::get('d3heidelpay'));
        oxRegistry::set('d3_d3heidelpay_models_settings_heidelpay', $settings);

        /** @var d3_d3heidelpay_models_factory $oFactory */
        $oFactory         = oxNew('d3_d3heidelpay_models_factory', d3_cfg_mod::get('d3heidelpay'));
        $sReferenceNumber = $oFactory->getReferenceNumber();
        if (empty($sReferenceNumber)) {
            $oFactory->initReferenceNumber();
        }

        $oHeidelpayViewConfig = oxNew(
            'd3_d3heidelpay_models_viewconfig',
            d3_cfg_mod::get('d3heidelpay'),
            oxRegistry::get('oxRegistry'),
            $oFactory
        );
        $this->addTplParam('oHeidelpayViewConfig', $oHeidelpayViewConfig);

        $oFactory->resetPaymentSuccess();

        $paymentId = oxRegistry::getSession()->getBasket()->getPaymentId();
        if (empty($paymentId)) {
            return;
        }

        $payment = oxNew('oxPayment');
        if (false == $payment->load($paymentId)) {
            return;
        }

        $oHeidelPaySettings = oxNew(
            'd3_d3heidelpay_models_settings_heidelpay',
            d3_cfg_mod::get('d3heidelpay')
        );

        try {
            if ($oHeidelPaySettings->isAssignedToHeidelPayment($payment)) {
                oxRegistry::getSession()->deleteVariable('sess_challenge');
            }
        } catch (d3_d3heidelpay_models_payment_exception_PaymentNotReferencedToHeidelpayException $exception) {
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->log(
                d3log::INFO,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'payment is not referenced to heidelpay',
                'paymentid: '. $payment . PHP_EOL. 'Exception: '.$exception->getMessage()
            );
        }
    }

    /**
     * Returns current selected payment id/number
     *
     * @return int
     */
    public function getD3CheckedPaymentCount()
    {
        $count = 0;
        if (d3_cfg_mod::get('d3heidelpay')->isActive()) {

            foreach ($this->getPaymentList() as $sPaymentID => $object) {
                if ($sPaymentID == $this->getCheckedPaymentId()) {
                    return $count;
                }
                $count++;
            }
        }

        return $count;
    }

    /**
     * Injects the Trusted Shops Excellence protection into the current session
     *
     * @return bool true if TSprotection is set, false if it was removed
     */
    public function setTsProtection()
    {
        $oBasket = $this->getSession()->getBasket();
        if (oxRegistry::getConfig()->getRequestParameter('bltsprotection')) {
            $sTsProductId = oxRegistry::getConfig()->getRequestParameter('stsprotection');
            $oBasket->setTsProductId($sTsProductId);
            oxRegistry::getSession()->setVariable('stsprotection', $sTsProductId);

            return true;
        }
        oxRegistry::getSession()->deleteVariable('stsprotection');
        $oBasket->setTsProductId(null);

        return false;
    }

    /**
     * Injects the Trusted Shops Excellence protection into the POST superglobal
     *
     * @return mixed
     */
    public function validatePayment()
    {
        $oBasket = $this->getSession()->getBasket();
        if ($oBasket->getTsProductId()) {
            $_POST['bltsprotection'] = true;
            $_POST['stsprotection']  = $oBasket->getTsProductId();
        }

        $return = parent::validatePayment();

        if(empty($return) || false === stristr($return, 'order')) {
            return $return;
        }

        $paymentId = oxRegistry::getConfig()->getRequestParameter('paymentid');
        if (empty($paymentId)) {
            $paymentId = $this->getSession()->getVariable('paymentid');
        }

        $payment = oxNew('oxPayment');
        $payment->load($paymentId);

        $heidelPaySettings = oxNew('d3_d3heidelpay_models_settings_heidelpay', d3_cfg_mod::get('d3heidelpay'));
        if (false == $heidelPaySettings->isAssignedToHeidelPayment($payment)) {
            return $return;
        }

        $heidelPayment = $heidelPaySettings->getPayment($payment);
        if (
            false == (
                $heidelPayment instanceof d3_d3heidelpay_models_payment_invoice_secured
                || $heidelPayment instanceof d3_d3heidelpay_models_payment_invoice_unsecured
            )
        ) {
            return $return;
        }

        $birthdate = $this->getConfig()->getRequestParameter('d3birthdate');

        if(empty($birthdate) || empty($birthdate[$paymentId]) || empty($birthdate[$paymentId]['day']) || empty($birthdate[$paymentId]['month']) || empty($birthdate[$paymentId]['year'])) {
            // log message
            d3_cfg_mod::get('d3heidelpay')->d3getLog()->log(
                d3log::WARNING,
                __CLASS__,
                __FUNCTION__,
                __LINE__,
                'birthdate is empty but required',
                'user didn\'t set the birthdate for invoice payment. input: '. var_export($birthdate, true)
            );
            $this->_sPaymentError = 1;

            return null;
        }

        $this->getUser()->assign(
            array('oxbirthdate' => $birthdate[$paymentId])
        );

        $this->getUser()->save();


        return $return;
    }

    /**
     * Returns id of user stored payment data
     *
     * @param $sPaymentId
     *
     * @return string
     */
    public function getUserHPStoreID($sPaymentId)
    {
        if (false == ($sUserID = $this->getSession()->getVariable("usr"))) {
            return '';
        }

        return oxDb::getDb()->getOne(
            "SELECT `oxid` FROM `d3hpuid` WHERE `oxuserid` = '$sUserID' AND `oxpaymentid` = '$sPaymentId'"
        );
    }

    /**
     * @param oxPayment $oPayment
     * @param string    $sTemplate
     *
     * @return string
     */
    public function d3GetPaymentFormTemplateName(oxPayment $oPayment, $sTemplate = '')
    {
        if(empty($sTemplate)) {
            $sTemplate = d3_cfg_mod::get('d3heidelpay')->getMappedThemeId();
        }

        $sTemplate = strtolower($sTemplate);

        /** @var d3_d3heidelpay_models_viewconfig $oHeidelpayViewConfig */
        $oHeidelpayViewConfig = oxNew(
            'd3_d3heidelpay_models_viewconfig',
            d3_cfg_mod::get('d3heidelpay'),
            oxRegistry::get('oxRegistry'),
            oxNew('d3_d3heidelpay_models_factory', d3_cfg_mod::get('d3heidelpay'))
        );
        $oHeidelPaySettings = $oHeidelpayViewConfig->getSettings();
        $return =  $this->d3GetDefaultPaymentFormTemplateName($oPayment);
        if ($oHeidelPaySettings->isAssignedToHeidelPayment($oPayment)) {
            $oHeidelPayment = $oHeidelPaySettings->getPayment($oPayment);
            if (
                $oHeidelPayment instanceof d3_d3heidelpay_models_payment_creditcard
             || $oHeidelPayment instanceof d3_d3heidelpay_models_payment_debitcard
            ) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_cards.tpl";
            } elseif ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_directdebit) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_debitnote.tpl";
            } elseif ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_sofortueberweisung) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_sofort.tpl";
            } elseif ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_giropay) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_giropay.tpl";
            } elseif ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_ideal) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_ideal.tpl";
            } elseif ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_eps) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_eps.tpl";
            } elseif ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_billsafe) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_billsafe.tpl";
            } elseif ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_paypal) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_paypal.tpl";
//            } elseif ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_postfinance) {
//                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_postfinance.tpl";
            } elseif ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_przelewy24) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_przelewy24.tpl";
            } elseif ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_masterpass) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_masterpass.tpl";
            } elseif (
                $oHeidelPayment instanceof d3_d3heidelpay_models_payment_invoice_secured
                || $oHeidelPayment instanceof d3_d3heidelpay_models_payment_invoice_unsecured
            ) {
                $return = "d3_d3heidelpay_views_{$sTemplate}_tpl_payment_invoice.tpl";
            }
        }

        return $return;
    }

    /**
     * @param oxPayment $oPayment
     *
     * @return bool
     * @throws d3_d3heidelpay_models_payment_exception_PaymentNotReferencedToHeidelpayException
     */
    public function d3IsHeidelpayPaymentMethode(oxPayment $oPayment)
    {
        /** @var d3_d3heidelpay_models_viewconfig $oHeidelpayViewConfig */
        $oHeidelpayViewConfig = oxNew(
        'd3_d3heidelpay_models_viewconfig',
        d3_cfg_mod::get('d3heidelpay'),
        oxRegistry::get('oxRegistry'),
        oxNew('d3_d3heidelpay_models_factory', d3_cfg_mod::get('d3heidelpay'))
        );
        $oHeidelPaySettings = $oHeidelpayViewConfig->getSettings();
        if ($oHeidelPaySettings->isAssignedToHeidelPayment($oPayment)) {
            $oHeidelPayment = $oHeidelPaySettings->getPayment($oPayment);
            if ($oHeidelPayment instanceof d3_d3heidelpay_models_payment_abstract) {
                return true;
            }

            return false;
        }

        return false;
    }


    /**
     * @param oxPayment $oPayment
     *
     * @return string
     */
    public function d3GetDefaultPaymentFormTemplateName(oxPayment $oPayment)
    {
        $sPaymentId = $oPayment->getId();

        if ($sPaymentId == "oxidcashondel") {
            return "page/checkout/inc/payment_oxidcashondel.tpl";
        } elseif ($sPaymentId == "oxidcreditcard") {
            return "page/checkout/inc/payment_oxidcreditcard.tpl";
        } elseif ($sPaymentId == "oxiddebitnote") {
            return "page/checkout/inc/payment_oxiddebitnote.tpl";
        } else {
            return "page/checkout/inc/payment_other.tpl";
        }
    }

    /**
     * @return bool
     */
    public function d3CheckForMobileTheme()
    {
        $blIsMobile = false;
        if ( class_exists('oeThemeSwitcherThemeManager') == true) {
            /** @var oeThemeSwitcherThemeManager $oThemeManager */
            $oThemeManager = new oeThemeSwitcherThemeManager();
            $blIsMobile = $oThemeManager->isMobileThemeRequested();
        }
        return $blIsMobile;
    }

    /**
     * @return string
     */
    public function render()
    {
        $mReturn = parent::render();

        $this->addTplParam('blD3HeidelpayAllowPostFinance', $this->isPaymentAllowed('CH', 'CHF'));
        $this->addTplParam('blD3HeidelpayAllowPrzelewy24', $this->isPaymentAllowed('PL', 'PLN'));

        return $mReturn;
    }

    /**
     * @param $sCountryIsoAlpha2
     * @param $sCurrencyName
     *
     * @return bool
     */
    public function isPaymentAllowed($sCountryIsoAlpha2, $sCurrencyName)
    {
        $sCountryId = $this->getUser()->getFieldData('oxcountryid');
        $blAllowed  = false;

        /** @var $oCountry oxcountry * */
        $oCountry = oxNew('oxcountry');
        if ($oCountry->load($sCountryId) && $oCountry->getFieldData('oxisoalpha2') == $sCountryIsoAlpha2 //
            && $this->getActCurrency()->name == $sCurrencyName
        ) {
            $blAllowed = true;

            return $blAllowed;
        }

        return $blAllowed;
    }

    public function d3GetMessageTemplateName()
    {
        $sTheme = 'd3_d3heidelpay_views_tpl_messages.tpl';
        $sTemplate = d3_cfg_mod::get('d3heidelpay')->getMappedThemeId();

        if ($sTemplate != 'azure') {
            $sTheme = "d3_d3heidelpay_views_{$sTemplate}_tpl_messages.tpl";
        }
        return $sTheme;
    }
}
