[{capture append="oxidBlock_content"}]
[{* ordering steps *}]

    [{oxscript include="js/widgets/oxinputvalidator.js" priority=10}]
    [{oxscript add="$('form.js-oxValidate').oxInputValidator();"}]

    [{assign var="currency" value=$oView->getActCurrency()}]
    [{assign var="payment" value=$oView->getPayment()}]

    [{assign var="sImageUrl" value=$oViewConf->getModuleUrl('d3heidelpay','out/img/')}]

    <!-- ordering steps -->
    [{include file="page/checkout/inc/steps.tpl" active=4}]
    <h1 class="pageHead">[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_TITLENR"}]</h1>
    <form method="post"
          action="[{$oHeidelpayViewConfig->getHeidelpayConfVar('sFormularUrl')}]"
          class="js-oxValidate payment"
          id="payform[{$inptcounter}]"
          autocomplete="off">

    <div id="payment">

    [{assign var="iPayError" value=$oHeidelpayViewConfig->getPaymentError()}]

    [{if $iPayError == 1}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_COMLETE_FIELDS_CORRECTLY"}]</div>
    [{elseif $iPayError == 2}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_AUTHORIZATION_FAILED"}]</div>
    [{elseif $iPayError == 4}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_UNAVAILABLE_SHIPPING_METHOD"}]</div>
    [{elseif $iPayError == 5}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_AUTHORIZATION_FAILED"}]</div>
    [{elseif $iPayError == 6}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_SHOP_UNAVAILABLE_PROTECTION"}]</div>
    [{elseif $iPayError > 6}]
        <!--Add custom error message here-->
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_AUTHORIZATION_FAILED"}]</div>
    [{elseif $iPayError == -1}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_NO_SHIPPING_METHOD_FOUND"}] "[{$oView->getPaymentErrorText()}]").</div>
    [{elseif $iPayError == -2}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_NO_SHIPPING_METHOD_FOUND"}]</div>
    [{elseif $iPayError == -3}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_SELECT_ANOTHER_PAYMENT"}]</div>
    [{elseif  $iPayError == -99}]
        [{assign var="hppayerror" value=$oHeidelpayViewConfig->getHeidelpayErrorText()}]
        <div class="status error">
            <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_ERROR"}]</div>
            [{if $hppayerror.OXCODE}]
                [{assign var="langident" value=$hppayerror.OXCODE}]
                <h3 style="color:#AA0000">[{oxmultilang ident="d3heidelpay_$langident"}]</h3>
            [{else}]
                <h3 style="color:#AA0000">[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_NOERRORTEXT"}]</h3>
            [{/if}]
            [{if $hppayerror.OXTYPE == "1"}]    [{* Fehlerkategorie: Eingabefehler *}]
                <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_CHECK"}]</div>
            [{elseif $hppayerror.OXTYPE == "2"}]    [{* Fehlerkategorie: Technischer Fehler *}]
                <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_TRYLATER"}]</div>
            [{elseif $hppayerror.OXTYPE == "3"}]    [{* Fehlerkategorie: Betrugsversuch? *}]
                <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_OTHERPAYMENT"}]</div>
            [{/if}]
        </div>
    [{/if}]

    <input type="hidden" name="FRONTEND.MODE" value="ASYNC">
    <input type="hidden"
           name="FRONTEND.RESPONSE_URL"
           value="[{$oViewConf->getModuleUrl('d3heidelpay','public/')}]hp_response.php">
    <input type="hidden"
           name="FRONTEND.SESSION_ID"
           value="[{$oViewConf->getSessionId()}]__@@step4__@@[{$oViewConf->getActLanguageId()}]__@@[{$oHeidelpayViewConfig->getHeidelpayConfVar('rtoken')}]__@@[{$oHeidelpayViewConfig->getHeidelpayConfVar('stoken')}]__@@[{$oViewConf->getActiveShopId()}]">
    <input type="hidden" name="FRONTEND.RETURN_ACCOUNT" value="true">
    <input type="hidden" name="REQUEST.VERSION" value="[{$oHeidelpayViewConfig->getHeidelpayConfVar('sVersion')}]">
    <input type="hidden" name="SECURITY.SENDER" value="[{$oHeidelpayViewConfig->getHeidelpayConfVar('sSecuritySender')}]">
    <input type="hidden" name="USER.LOGIN" value="[{$oHeidelpayViewConfig->getHeidelpayConfVar('sUserID')}]">
    <input type="hidden" name="USER.PWD" value="[{$oHeidelpayViewConfig->getHeidelpayConfVar('sPassword')}]">
    <input type="hidden" name="TRANSACTION.MODE" value="[{$oHeidelpayViewConfig->getHeidelpayConfVar('sFormularMode')}]">
    <input type="hidden" name="TRANSACTION.RESPONSE" value="SYNC">
    <input type="hidden" name="TRANSACTION.CHANNEL" value="[{$oHeidelpayViewConfig->getHeidelpayConfVar('sChannel')}]">
    <input type="hidden"
           name="IDENTIFICATION.TRANSACTIONID"
           value="[{$oHeidelpayViewConfig->getHeidelpayConfVar('sTransactionId')}]">
    <input type="hidden"
           name="PAYMENT.CODE"
           value="[{$oHeidelpayViewConfig->getPaymentCode($payment->getId())}].[{$oHeidelpayViewConfig->getHeidelpayConfVar('sTransType')}]">
    [{if $oxcmp_user->oxuser__oxfname->value}]
        <input type="hidden" name="NAME.GIVEN" value="[{$oxcmp_user->oxuser__oxfname->value}]">
    [{else}]
        <input type="hidden" name="NAME.GIVEN" value="name-given">
    [{/if}]
    [{if $oxcmp_user->oxuser__oxlname->value}]
        <input type="hidden" name="NAME.FAMILY" value="[{$oxcmp_user->oxuser__oxlname->value}]">
    [{else}]
        <input type="hidden" name="NAME.FAMILY" value="name-family">
    [{/if}]
    <input type="hidden"
           name="ADDRESS.STREET"
           value="[{$oxcmp_user->oxuser__oxstreet->value}] [{$oxcmp_user->oxuser__oxstreetnr->value}]">
    <input type="hidden" name="ADDRESS.ZIP" value="[{$oxcmp_user->oxuser__oxzip->value}]">
    <input type="hidden" name="ADDRESS.CITY" value="[{$oxcmp_user->oxuser__oxcity->value}]">
    <input type="hidden" name="ADDRESS.STATE" value="">
    <input type="hidden" name="ADDRESS.COUNTRY" value="[{assign var='oCountry' value=$oHeidelpayViewConfig->getCountry()}][{$oCountry->getFieldData('oxisoalpha2')}]">
    <input type="hidden" name="CONTACT.EMAIL" value="[{$oxcmp_user->oxuser__oxusername->value}]">
    <input type="hidden" name="CONTACT.IP" value="[{$oHeidelpayViewConfig->getHeidelpayConfVar('sUserIp')}]">
    <input type="hidden" name="RISKMANAGEMENT.PROCESS" value="AUTO">
    <input type="hidden" name="PRESENTATION.AMOUNT" value="[{$oHeidelpayViewConfig->getHeidelpayConfVar('iBasketAmount')}]">
    <input type="hidden" name="PRESENTATION.CURRENCY" value="[{$currency->name}]">
    <input type="hidden" name="PRESENTATION.USAGE" value="[{$oxcmp_shop->oxshops__oxname->value}]">
    <input type="hidden"
           name="FRONTEND.RESPONSEURL"
           value="[{$oViewConf->getModuleUrl('d3heidelpay','public/')}]hp_response.php">
    <input type="hidden"
           name="FRONTEND.SESSIONID"
           value="[{$oViewConf->getSessionId()}]__@@step4__@@[{$oViewConf->getActLanguageId()}]__@@[{$oHeidelpayViewConfig->getHeidelpayConfVar('rtoken')}]__@@[{$oHeidelpayViewConfig->getHeidelpayConfVar('stoken')}]__@@[{$oViewConf->getActiveShopId()}]">


    [{if $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "CC"}]
        [{assign var="aCCTypes" value=$oHeidelpayViewConfig->getCardTypes('CC')}]
        [{if $aCCTypes.MASTER}]
            <img src="[{$sImageUrl}]logo_master.jpg" alt="Mastercard" style="vertical-align: middle;">
        [{/if}]
        [{if $aCCTypes.VISA}]
            <img src="[{$sImageUrl}]logo_visa.jpg" alt="Visa" style="vertical-align: middle;">
        [{/if}]
        [{if $aCCTypes.AMEX}]
            <img src="[{$sImageUrl}]logo_amex.jpg" alt="American Express" style="vertical-align: middle;">
        [{/if}]
        [{if $aCCTypes.JCB}]
            <img src="[{$sImageUrl}]logo_jcb.jpg" alt="JCB" style="vertical-align: middle;">
        [{/if}]
        [{if $aCCTypes.DISCOVER}]
            <img src="[{$sImageUrl}]logo_discover.jpg" alt="Discover" style="vertical-align: middle;">
        [{/if}]
        [{if $aCCTypes.DINERS}]
            <img src="[{$sImageUrl}]logo_diners.jpg" alt="Diners Club" style="vertical-align: middle;">
        [{/if}]

    [{elseif $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "DC"}]
        [{assign var="aDCTypes" value=$oHeidelpayViewConfig->getCardTypes('DC')}]
        [{if $aDCTypes.VISAELECTRON}]
            <img src="[{$sImageUrl}]logo_visaelectron.jpg" alt="VisaElectron" style="vertical-align: middle;">
        [{/if}]
        [{if $aDCTypes.MAESTRO}]
            <img src="[{$sImageUrl}]logo_maestro.jpg" alt="Maestro" style="vertical-align: middle;">
        [{/if}]
        [{if $aDCTypes.CARTEBLEUE}]
            <img src="[{$sImageUrl}]logo_cartebleue.jpg" alt="CarteBleue" style="vertical-align: middle;">
        [{/if}]
        [{if $aDCTypes.SOLO}]
            <img src="[{$sImageUrl}]logo_solo.jpg" alt="Solo" style="vertical-align: middle;">
        [{/if}]
        [{if $aDCTypes.POSTEPAY}]
            <img src="[{$sImageUrl}]logo_postepay.jpg" alt="Postepay" style="vertical-align: middle;">
        [{/if}]
        [{if $aDCTypes.EURO6000}]
            <img src="[{$sImageUrl}]logo_euro6000.jpg" alt="Euro6000" style="vertical-align: middle;">
        [{/if}]
        [{if $aDCTypes.SERVIRED}]
            <img src="[{$sImageUrl}]logo_servired.jpg" alt="ServiRed" style="vertical-align: middle;">
        [{/if}]
        [{if $aDCTypes.4B}]
            <img src="[{$sImageUrl}]logo_4b.jpg" alt="4B" style="vertical-align: middle;">
        [{/if}]
        [{if $aDCTypes.DANKORT}]
            <img src="[{$sImageUrl}]logo_dankort.jpg" alt="Dankort" style="vertical-align: middle;">
        [{/if}]
    [{/if}]

    <ul class="form">
        <li>
            <label>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_CARD"}]</label>
            <select name="ACCOUNT.BRAND" class="payment_text js-oxValidate js-oxValidate_notEmpty">
                <option value="">[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_SELECTPLEASE"}]</option>
                [{if $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "CC"}]
                    [{assign var="aCCTypes" value=$oHeidelpayViewConfig->getCardTypes('CC')}]
                    [{if $aCCTypes.MASTER}]
                        <option value="MASTER">Mastercard</option>
                    [{/if}]
                    [{if $aCCTypes.VISA}]
                        <option value="VISA">VISA</option>
                    [{/if}]
                    [{if $aCCTypes.AMEX}]
                        <option value="AMEX">American Express</option>
                    [{/if}]
                    [{if $aCCTypes.DINERS}]
                        <option value="DINERS">Diners Club</option>
                    [{/if}]
                    [{if $aCCTypes.DISCOVER}]
                        <option value="DISCOVER">Discover</option>
                    [{/if}]
                    [{if $aCCTypes.JCB}]
                        <option value="JCB">JCB</option>
                    [{/if}]
                [{elseif $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "DC"}]
                    [{assign var="aDCTypes" value=$oHeidelpayViewConfig->getCardTypes('DC')}]
                    [{if $aDCTypes.VISAELECTRON}]
                        <option value="VISAELECTRON">VISA Electron</option>
                    [{/if}]
                    [{if $aDCTypes.MAESTRO}]
                        <option value="MAESTRO">MAESTRO</option>
                    [{/if}]
                    [{if $aDCTypes.CARTEBLEUE}]
                        <option value="CARTEBLEUE">Carte Bleue</option>
                    [{/if}]
                    [{if $aDCTypes.SOLO}]
                        <option value="SOLO">SOLO</option>
                    [{/if}]
                    [{if $aDCTypes.SWITCH}]
                        <option value="SWITCH">SWITCH</option>
                    [{/if}]
                    [{if $aDCTypes.POSTEPAY}]
                        <option value="POSTEPAY">Postepay</option>
                    [{/if}]
                    [{if $aDCTypes.EURO6000}]
                        <option value="EURO6000">Euro 6000</option>
                    [{/if}]
                    [{if $aDCTypes.SERVIRED}]
                        <option value="SERVIRED">ServiRed</option>
                    [{/if}]
                    [{if $aDCTypes.4B}]
                        <option value="4B">4B</option>
                    [{/if}]
                    [{if $aDCTypes.DANKORT}]
                        <option value="DANKORT">Dankort</option>
                    [{/if}]
                [{/if}]
            </select>

            <p class="oxValidateError">
                <span class="js-oxError_notEmpty">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_PAGE_EXCEPTION_INPUT_NOTALLFIELDS"}]</span>
            </p>
        </li>
        <li>
            <label>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_NUMBER"}]:</label>
            <input type="text"
                   class="payment_text js-oxValidate js-oxValidate_notEmpty"
                   size="20"
                   maxlength="16"
                   id="account_number"
                   name="ACCOUNT.NUMBER"
                   value="">

            <p class="oxValidateError">
                <span class="js-oxError_notEmpty">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_PAGE_EXCEPTION_INPUT_NOTALLFIELDS"}]</span>
            </p>
        </li>
        <li>
            <label>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_OWNER"}]:</label>
            <input type="text"
                   class="font10 payment_text js-oxValidate js-oxValidate_notEmpty"
                   size="20"
                   maxlength="64"
                   name="ACCOUNT.HOLDER"
                   value="[{$oxcmp_user->oxuser__oxfname->value}] [{$oxcmp_user->oxuser__oxlname->value}]">

            <p class="oxValidateError">
                <span class="js-oxError_notEmpty">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_PAGE_EXCEPTION_INPUT_NOTALLFIELDS"}]</span>
            </p>
        </li>
        <li>
            <label>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_EXPIRES"}]</label>
            <select name="ACCOUNT.MONTH" class="font10">
                <option [{if $dynvalue.kkmonth == "01"}]selected[{/if}]>01</option>
                <option [{if $dynvalue.kkmonth == "02"}]selected[{/if}]>02</option>
                <option [{if $dynvalue.kkmonth == "03"}]selected[{/if}]>03</option>
                <option [{if $dynvalue.kkmonth == "04"}]selected[{/if}]>04</option>
                <option [{if $dynvalue.kkmonth == "05"}]selected[{/if}]>05</option>
                <option [{if $dynvalue.kkmonth == "06"}]selected[{/if}]>06</option>
                <option [{if $dynvalue.kkmonth == "07"}]selected[{/if}]>07</option>
                <option [{if $dynvalue.kkmonth == "08"}]selected[{/if}]>08</option>
                <option [{if $dynvalue.kkmonth == "09"}]selected[{/if}]>09</option>
                <option [{if $dynvalue.kkmonth == "10"}]selected[{/if}]>10</option>
                <option [{if $dynvalue.kkmonth == "11"}]selected[{/if}]>11</option>
                <option [{if $dynvalue.kkmonth == "12"}]selected[{/if}]>12</option>
            </select>&nbsp;/&nbsp;
            [{assign var="year" value=$smarty.now|date_format:"%Y"}]
            <select name="ACCOUNT.YEAR" class="font10">
                [{section name=year start=$year loop=2100 max=10 step=1}]
                    <option [{if $dynvalue.kkyear == $year}]selected[{/if}]>[{$smarty.section.year.index}]</option>
                [{/section}]
            </select>
        </li>
        <li>
            <label>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_VN"}]</label>
            <input type="text"
                   class="payment_text payment_text js-oxValidate js-oxValidate_notEmpty"
                   size="6"
                   maxlength="4"
                   id="account_verification"
                   name="ACCOUNT.VERIFICATION"
                   value="[{$dynvalue.kkpruef}]">

            <p class="oxValidateError">
                <span class="js-oxError_notEmpty">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_PAGE_EXCEPTION_INPUT_NOTALLFIELDS"}]</span>
            </p>
        </li>
        <li>
            [{oxmultilang ident="D3PAYMENT_SECURITYCODEDESCRIPTION"}]
            [{if $aCCTypes.AMEX && $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "CC"}]
                [{oxmultilang ident="D3PAYMENT_SECURITYCODEDESCRIPTION_AMEX"}]
            [{/if}]
        </li>
        <li>
            <img src="[{$sImageUrl}]pruefziffer_visa.jpg" alt="visa">
            [{if $aCCTypes.AMEX && $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "CC"}]
                <img src="[{$sImageUrl}]pruefziffer_amex.jpg" alt="visa">
            [{/if}]
        </li>
    </ul>
    [{if $payment->oxpayments__oxlongdesc->value}]
        <div class="desc">
            [{$payment->oxpayments__oxlongdesc->value}]
        </div>
    [{/if}]
    </div>

    <div class="lineBox clear">
        <a href="[{oxgetseourl ident=$oViewConf->getSelfLink()|cat:"cl=order"}]"
           class="submitButton largeButton">[{oxmultilang ident="D3HEIDELPAY_ORDER_PAGE_BACKSTEPT"}]</a>
        <button type="submit"
                name="userform"
                class="submitButton nextStep largeButton"
                id="paymentNextStepBottom">[{oxmultilang ident="D3HEIDELPAY_ORDER_PAGE_NEXTSTEP"}]</button>
    </div>
    </form>
    <div id="d3HeidelpayWait" class="popupBox corners FXgradGreyLight glowShadow">
        <table class="d3HeidelpayInfoTable" cellpadding="0" cellspacing="0">
            <tr>
                <td class="d3HeidelpayInfoCell">[{oxmultilang ident="D3HEIDELPAY_SENDING_FORMULAR"}]</td>
            </tr>
        </table>
    </div>
    [{oxscript add="
jQuery( '#d3HeidelpayWait' ).dialog({
    autoOpen: false,
    modal: true,
    width        : 540,
    height       : 'auto',
    zIndex       : 10000,
    position     : 'center',
    draggable    : false,
    closeOnEscape: false,
    resizable: false,
    show: 'drop',
    hide: 'drop',
    open: function(event, ui) {
        jQuery('div.ui-dialog-titlebar').remove();
    }
});
jQuery( 'form.js-oxValidate' ).submit(function() {
    if (jQuery( this ).find( '.oxInValid').length <= 0) {
        jQuery( '#d3HeidelpayWait' ).dialog( 'open' );
        jQuery('#paymentNextStepBottom').attr('disabled', true);
    }
});"}]

    [{oxstyle include="css/d3heidelpay.css"}]

    [{insert name="oxid_tracker" title=$template_title}]
[{/capture}]
[{include file="layout/page.tpl"}]
