<?php

/**
 * Class d3_oxEmail_heidelpay
 */
class d3_oxemail_heidelpay extends d3_oxemail_heidelpay_parent
{

    /**
     * Sends customer heidelpay information e-mail
     *
     * @param $oOrder
     *
     * @return bool
     */
    public function d3SendCustHPPPInfoMail($oOrder)
    {
        $myConfig = $this->getConfig();

        //sets language of shop
        $iCurrLang = (int)$myConfig->getActiveShop()->getLanguage();

        // shop info
        $oShop = $this->_getShop($iCurrLang);

        $this->_setMailParams($oShop);

        // create messages
        $smarty = $this->_getSmarty();
        $this->setViewData("order", $oOrder);

        // Process view data array through oxoutput processor
        $this->_processViewArray();

        $this->setBody($smarty->fetch('hp_prepayment_cust_html.tpl'));
        $this->setAltBody($smarty->fetch('hp_prepayment_cust_plain.tpl'));
        $this->setSubject($smarty->fetch('hp_prepayment_cust_subj.tpl'));

        $sEMailAdress = $oOrder->oxorder__oxbillemail->value;

        $sFullName = $oOrder->oxorder__oxbillfname->value . " " . $oOrder->oxorder__oxbilllname->value;

        $this->setRecipient($sEMailAdress, $sFullName);
        $this->setReplyTo($oShop->oxshops__oxinfoemail->value, $oShop->oxshops__oxname->value);
        $this->setFrom($oShop->oxshops__oxinfoemail->value, $oShop->oxshops__oxname->getRawValue());

        $blReturn = $this->send();

        return $blReturn;
    }

    /**
     * Sends owner  heidelpay information e-mail
     *
     * @param $oOrder
     *
     * @return bool
     */
    public function d3SendOwnerHPPPInfoMail($oOrder)
    {
        $myConfig = $this->getConfig();

        //sets language of sho
        $iCurrLang = (int)$myConfig->getActiveShop()->getLanguage();

        // shop info
        $oShop = $this->_getShop($iCurrLang);

        $this->_setMailParams($oShop);

        // create messages
        $smarty = $this->_getSmarty();
        $this->setViewData("order", $oOrder);

        // Process view data array through oxoutput processor
        $this->_processViewArray();

        $this->setBody($smarty->fetch("hp_prepayment_owner_html.tpl"));
        $this->setAltBody($smarty->fetch("hp_prepayment_owner_plain.tpl"));
        $this->setSubject($smarty->fetch("hp_prepayment_owner_subj.tpl"));

        $this->setRecipient($oShop->oxshops__oxinfoemail->value, "");
        $sEmailAddress = $oShop->oxshops__oxowneremail->value;

        $this->setFrom($sEmailAddress, "");
        $this->setReplyTo($sEmailAddress, "");

        $blReturn = $this->send();

        return $blReturn;
    }
}
