[{capture append="oxidBlock_content"}]
[{* ordering steps *}]

    [{oxscript include="js/widgets/oxinputvalidator.js" priority=10}]
    [{oxscript add="$('form.js-oxValidate').oxInputValidator();"}]

    [{assign var="currency" value=$oView->getActCurrency()}]
    [{assign var="payment" value=$oView->getPayment()}]

    [{assign var='oHeidelPaySettings' value=$oHeidelpayViewConfig->getSettings()}]
    [{assign var='oHeidelPayment' value=$oHeidelPaySettings->getPayment($payment)}]
    [{assign var="aBrands" value=$oHeidelpayViewConfig->getHeidelpayNgwBrands($payment, $oHeidelPayment, $oxcmp_user, $oHeidelpayViewConfig->getHeidelpayConfVar('sTransType'))}]

    [{assign var="sImageUrl" value=$oViewConf->getModuleUrl('d3heidelpay','out/img/')}]

    <!-- ordering steps -->
    [{include file="page/checkout/inc/steps.tpl" active=4}]
    <h1 class="pageHead">[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_TITLENR"}]</h1>
    <form method="post" action="[{$oHeidelpayViewConfig->getHeidelpayNgwRequestUrl($payment, $oHeidelPayment, $oxcmp_user, $oHeidelpayViewConfig->getHeidelpayConfVar('sTransType'))}]" class="js-oxValidate payment" id="payform[{$inptcounter}]" autocomplete="off">

    <div id="payment">

    [{assign var="iPayError" value=$oHeidelpayViewConfig->getPaymentError()}]

    [{if $iPayError == 1}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_COMLETE_FIELDS_CORRECTLY"}]</div>
    [{elseif $iPayError == 2}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_AUTHORIZATION_FAILED"}]</div>
    [{elseif $iPayError == 4}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_UNAVAILABLE_SHIPPING_METHOD"}]</div>
    [{elseif $iPayError == 5}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_AUTHORIZATION_FAILED"}]</div>
    [{elseif $iPayError == 6}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_SHOP_UNAVAILABLE_PROTECTION"}]</div>
    [{elseif $iPayError > 6}]
        <!--Add custom error message here-->
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_AUTHORIZATION_FAILED"}]</div>
    [{elseif $iPayError == -1}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_NO_SHIPPING_METHOD_FOUND"}] "[{$oView->getPaymentErrorText()}]").</div>
    [{elseif $iPayError == -2}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_NO_SHIPPING_METHOD_FOUND"}]</div>
    [{elseif $iPayError == -3}]
        <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_SELECT_ANOTHER_PAYMENT"}]</div>
    [{elseif  $iPayError == -99}]
        [{assign var="hppayerror" value=$oHeidelpayViewConfig->getHeidelpayErrorText()}]
        <div class="status error">
            <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_ERROR"}]</div>
            [{if $hppayerror.OXCODE}]
                [{assign var="langident" value=$hppayerror.OXCODE}]
                <h3 style="color:#AA0000;">[{oxmultilang ident="d3heidelpay_$langident"}]</h3>
            [{else}]
                <h3 style="color:#AA0000;">[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_NOERRORTEXT"}]</h3>
            [{/if}]
            [{if $hppayerror.OXTYPE == "1"}]    [{* Fehlerkategorie: Eingabefehler *}]
                <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_CHECK"}]</div>
            [{elseif $hppayerror.OXTYPE == "2"}]    [{* Fehlerkategorie: Technischer Fehler *}]
                <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_TRYLATER"}]</div>
            [{elseif $hppayerror.OXTYPE == "3"}]    [{* Fehlerkategorie: Betrugsversuch? *}]
                <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_OTHERPAYMENT"}]</div>
            [{/if}]
        </div>
    [{/if}]

    [{foreach from=$aBrands item='sBrandName' key='sBrandIdent'}]
        [{if $sBrandIdent == 'MASTER'}]<img src="[{$sImageUrl}]logo_master.jpg" alt="Mastercard" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'VISA'}]<img src="[{$sImageUrl}]logo_visa.jpg" alt="Visa" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'AMEX'}]<img src="[{$sImageUrl}]logo_amex.jpg" alt="AmEx" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'DINERS'}]<img src="[{$sImageUrl}]logo_diners.jpg" alt="DINERS" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'DISCOVERY'}]<img src="[{$sImageUrl}]logo_discover.jpg" alt="DISCOVERY" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'VISAELECTRON'}]<img src="[{$sImageUrl}]logo_visaelectron.jpg" alt="VisaElectron" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'MAESTRO'}]<img src="[{$sImageUrl}]logo_maestro.jpg" alt="Maestro" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'CARTEBLEUE'}]<img src="[{$sImageUrl}]logo_cartebleue.jpg" alt="CarteBleue" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'SOLO'}]<img src="[{$sImageUrl}]logo_solo.jpg" alt="Solo" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'POSTEPAY'}]<img src="[{$sImageUrl}]logo_postepay.jpg" alt="Postepay" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'EURO6000'}]<img src="[{$sImageUrl}]logo_euro6000.jpg" alt="Euro6000" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'SERVIRED'}]<img src="[{$sImageUrl}]logo_servired.jpg" alt="ServiRed" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == '4B'}]<img src="[{$sImageUrl}]logo_4b.jpg" alt="4B" style="vertical-align: middle;">[{/if}]
        [{if $sBrandIdent == 'DANKORT'}]<img src="[{$sImageUrl}]logo_dankort.jpg" alt="Dankort" style="vertical-align: middle;">[{/if}]
    [{/foreach}]

    <ul class="form">
        <li>
            <label>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_CARD"}]</label>
            <select name="ACCOUNT.BRAND" class="payment_text js-oxValidate js-oxValidate_notEmpty">
                <option value="">[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_SELECTPLEASE"}]</option>
                [{foreach from=$aBrands item='sBrandName' key='sBrandIdent'}]
                    <option value="[{$sBrandIdent}]" [{if ($dynvalue.kktype == $sBrandIdent)}]selected[{/if}]>[{$sBrandName}]</option>
                [{/foreach}]
            </select>

            <p class="oxValidateError">
                <span class="js-oxError_notEmpty">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_PAGE_EXCEPTION_INPUT_NOTALLFIELDS"}]</span>
            </p>
        </li>
        <li>
            <label>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_NUMBER"}]:</label>
            <input type="text"
                   class="payment_text js-oxValidate js-oxValidate_notEmpty"
                   size="20"
                   maxlength="16"
                   id="account_number"
                   name="ACCOUNT.NUMBER"
                   value="">

            <p class="oxValidateError">
                <span class="js-oxError_notEmpty">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_PAGE_EXCEPTION_INPUT_NOTALLFIELDS"}]</span>
            </p>
        </li>
        <li>
            <label>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_OWNER"}]:</label>
            <input type="text"
                   class="font10 payment_text js-oxValidate js-oxValidate_notEmpty"
                   size="20"
                   maxlength="64"
                   name="ACCOUNT.HOLDER"
                   value="[{$oxcmp_user->oxuser__oxfname->value}] [{$oxcmp_user->oxuser__oxlname->value}]">

            <p class="oxValidateError">
                <span class="js-oxError_notEmpty">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_PAGE_EXCEPTION_INPUT_NOTALLFIELDS"}]</span>
            </p>
        </li>
        <li>
            <label>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_EXPIRES"}]</label>
            <select name="ACCOUNT.EXPIRY_MONTH" class="font10">
                <option [{if $dynvalue.kkmonth == "01"}]selected[{/if}]>01</option>
                <option [{if $dynvalue.kkmonth == "02"}]selected[{/if}]>02</option>
                <option [{if $dynvalue.kkmonth == "03"}]selected[{/if}]>03</option>
                <option [{if $dynvalue.kkmonth == "04"}]selected[{/if}]>04</option>
                <option [{if $dynvalue.kkmonth == "05"}]selected[{/if}]>05</option>
                <option [{if $dynvalue.kkmonth == "06"}]selected[{/if}]>06</option>
                <option [{if $dynvalue.kkmonth == "07"}]selected[{/if}]>07</option>
                <option [{if $dynvalue.kkmonth == "08"}]selected[{/if}]>08</option>
                <option [{if $dynvalue.kkmonth == "09"}]selected[{/if}]>09</option>
                <option [{if $dynvalue.kkmonth == "10"}]selected[{/if}]>10</option>
                <option [{if $dynvalue.kkmonth == "11"}]selected[{/if}]>11</option>
                <option [{if $dynvalue.kkmonth == "12"}]selected[{/if}]>12</option>
            </select>&nbsp;/&nbsp;
            [{assign var="year" value=$smarty.now|date_format:"%Y"}]
            <select name="ACCOUNT.EXPIRY_YEAR" class="font10">
                [{section name=year start=$year loop=2100 max=10 step=1}]
                    <option [{if $dynvalue.kkyear == $year}]selected[{/if}]>[{$smarty.section.year.index}]</option>
                [{/section}]
            </select>
        </li>
        <li>
            <label>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_VN"}]</label>
            <input type="text"
                   class="payment_text payment_text js-oxValidate js-oxValidate_notEmpty"
                   size="6"
                   maxlength="4"
                   id="account_verification"
                   name="ACCOUNT.VERIFICATION"
                   value="[{$dynvalue.kkpruef}]">

            <p class="oxValidateError">
                <span class="js-oxError_notEmpty">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_PAGE_EXCEPTION_INPUT_NOTALLFIELDS"}]</span>
            </p>
        </li>
        <li>
            [{oxmultilang ident="D3PAYMENT_SECURITYCODEDESCRIPTION"}]
            [{if $aCCTypes.AMEX && $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "CC"}]
                [{oxmultilang ident="D3PAYMENT_SECURITYCODEDESCRIPTION_AMEX"}]
            [{/if}]
        </li>
        <li>
            <img src="[{$sImageUrl}]pruefziffer_visa.jpg" alt="visa">
            [{if $aCCTypes.AMEX && $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "CC"}]
                <img src="[{$sImageUrl}]pruefziffer_amex.jpg" alt="visa">
            [{/if}]
        </li>
    </ul>
    [{if $payment->oxpayments__oxlongdesc->value}]
        <div class="desc">
            [{$payment->oxpayments__oxlongdesc->value}]
        </div>
    [{/if}]
    </div>

    <div class="lineBox clear">
        <a href="[{oxgetseourl ident=$oViewConf->getSelfLink()|cat:"cl=order"}]"
           class="submitButton largeButton">[{oxmultilang ident="D3HEIDELPAY_ORDER_PAGE_BACKSTEPT"}]</a>
        <button type="submit"
                name="userform"
                class="submitButton nextStep largeButton"
                id="paymentNextStepBottom">[{oxmultilang ident="D3HEIDELPAY_ORDER_PAGE_NEXTSTEP"}]</button>
    </div>
    </form>
    <div id="d3HeidelpayWait" class="popupBox corners FXgradGreyLight glowShadow">
        <table class="d3HeidelpayInfoTable" cellpadding="0" cellspacing="0">
            <tr>
                <td class="d3HeidelpayInfoCell">[{oxmultilang ident="D3HEIDELPAY_SENDING_FORMULAR"}]</td>
            </tr>
        </table>
    </div>
    [{oxscript add="
jQuery( '#d3HeidelpayWait' ).dialog({
    autoOpen: false,
    modal: true,
    width        : 540,
    height       : 'auto',
    zIndex       : 10000,
    position     : 'center',
    draggable    : false,
    closeOnEscape: false,
    resizable: false,
    show: 'drop',
    hide: 'drop',
    open: function(event, ui) {
        jQuery('div.ui-dialog-titlebar').remove();
    }
});
jQuery( 'form.js-oxValidate' ).submit(function() {
    if (jQuery( this ).find( '.oxInValid').length <= 0) {
        jQuery( '#d3HeidelpayWait' ).dialog( 'open' );
        jQuery('#paymentNextStepBottom').attr('disabled', true);
    }
});"}]

    [{insert name="oxid_tracker" title=$template_title}]
[{/capture}]
[{include file="layout/page.tpl"}]
