[{capture append="oxidBlock_content"}]
[{oxscript include="js/widgets/oxdropdown.js" priority=10}]
[{oxscript include="js/widgets/oxpaymentmethods.js" priority=10}]

[{oxscript include="js/widgets/oxinputvalidator.js" priority=10}]
[{oxscript add="$('form.js-oxValidate').oxInputValidator();"}]
<div id="paymentSelect" class="content payment-select">

    [{* ordering steps *}]
    [{include file="page/checkout/inc/steps.tpl" active=4}]

    [{assign var="currency" value=$oView->getActCurrency()}]
    [{assign var="payment" value=$oView->getPayment()}]

    [{assign var='oHeidelPaySettings' value=$oHeidelpayViewConfig->getSettings()}]
    [{assign var='oHeidelPayment' value=$oHeidelPaySettings->getPayment($payment)}]
    [{assign var="aBrands" value=$oHeidelpayViewConfig->getHeidelpayNgwBrands($payment, $oHeidelPayment, $oxcmp_user, $oHeidelpayViewConfig->getHeidelpayConfVar('sTransType'))}]
    [{assign var="sImageUrl" value=$oViewConf->getModuleUrl('d3heidelpay','out/img/')}]
    [{*assign var="dynvalue" value=$oView->getDynValue()*}]

    <h1 class="pageHead">[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_TITLENR"}]</h1>
    <form method="post" action="[{$oHeidelpayViewConfig->getHeidelpayNgwRequestUrl($payment, $oHeidelPayment, $oxcmp_user, $oHeidelpayViewConfig->getHeidelpayConfVar('sTransType'))}]" class="js-oxValidate payment" id="payform[{$inptcounter}]" autocomplete="off">

    <div id="payment">
        <div class="payment-row">
            [{assign var="iPayError" value=$oHeidelpayViewConfig->getPaymentError()}]
            [{if !empty($iPayError)}]
                [{if $iPayError == 1}]
                    <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_COMLETE_FIELDS_CORRECTLY"}]</div>
                [{elseif $iPayError == 2}]
                    <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_AUTHORIZATION_FAILED"}]</div>
                [{elseif $iPayError == 4}]
                    <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_UNAVAILABLE_SHIPPING_METHOD"}]</div>
                [{elseif $iPayError == 5}]
                    <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_AUTHORIZATION_FAILED"}]</div>
                [{elseif $iPayError == 6}]
                    <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_SHOP_UNAVAILABLE_PROTECTION"}]</div>
                [{elseif $iPayError > 6}]
                    <!--Add custom error message here-->
                    <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_AUTHORIZATION_FAILED"}]</div>
                [{elseif $iPayError == -1}]
                    <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_NO_SHIPPING_METHOD_FOUND"}] "[{$oView->getPaymentErrorText()}]").</div>
                [{elseif $iPayError == -2}]
                    <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_NO_SHIPPING_METHOD_FOUND"}]</div>
                [{elseif $iPayError == -3}]
                    <div class="status error">[{oxmultilang ident="D3HEIDELPAY_CC_ERRROR_MESSAGE_PAYMENT_SELECT_ANOTHER_PAYMENT"}]</div>
                [{elseif  $iPayError == -99}]
                    [{assign var="hppayerror" value=$oHeidelpayViewConfig->getHeidelpayErrorText()}]
                    <div class="status error">
                        <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_ERROR"}]</div>
                        [{if $hppayerror.OXCODE}]
                            [{assign var="langident" value=$hppayerror.OXCODE}]
                            <h3 style="color:#AA0000;">[{oxmultilang ident="d3heidelpay_$langident"}]</h3>
                        [{else}]
                            <h3 style="color:#AA0000;">[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_NOERRORTEXT"}]</h3>
                        [{/if}]
                        [{if $hppayerror.OXTYPE == "1"}]    [{* Fehlerkategorie: Eingabefehler *}]
                            <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_CHECK"}]</div>
                        [{elseif $hppayerror.OXTYPE == "2"}]    [{* Fehlerkategorie: Technischer Fehler *}]
                            <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_TRYLATER"}]</div>
                        [{elseif $hppayerror.OXTYPE == "3"}]    [{* Fehlerkategorie: Betrugsversuch? *}]
                            <div>[{oxmultilang ident="D3HEIDELPAY_CC_INPUT_OTHERPAYMENT"}]</div>
                        [{/if}]
                    </div>
                [{/if}]
            [{/if}]

            <ul class="form">
                <li>
                    [{include file="img_creditcard_mobile.tpl" aBrands=$aBrands}]
                </li>
                <li>
                    <div class="dropdown">
                        <input type="hidden" id="sCreditCardSelected" name="ACCOUNT.BRAND" value="VISA" />

                        [{if $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "DC"}]
                            <input type="hidden" id="sCreditCardSelected" name="ACCOUNT.BRAND" value="VISAELECTRON" />
                        [{elseif $aCCTypes.MASTER}]
                            <input type="hidden" id="sCreditCardSelected" name="ACCOUNT.BRAND" value="MASTER" />
                        [{/if}]

                        <div class="dropdown-toggle" data-toggle="dropdown" data-target="#">
                            <a id="dLabelCreditCardSelected" role="button" href="#">
                                <span id="creditCardSelected">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_INPUT_CREDITCARD"}]</span>
                                <i class="glyphicon-chevron-down"></i>
                            </a>
                        </div>
                        <ul class="dropdown-menu" role="menu" aria-labelledby="dLabelCreditCardSelected">
                            [{foreach from=$aBrands item='sBrandName' key='sBrandIdent'}]
                                <li class="dropdown-option[{if ($dynvalue.kktype == $sBrandIdent)}] selected[{/if}]">
                                    <a tabindex="-1" data-selection-id="[{$sBrandIdent}]">[{$sBrandName}]</a>
                                </li>
                            [{/foreach}]
                        </ul>
                    </div>
                </li>
                <li>
                    <label for="ACCOUNT.NUMBER">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_INPUT_NUMBER"}]</label>
                    <input type="number" class="js-oxValidate js-oxValidate_notEmpty" size="64" maxlength="64" name="ACCOUNT.NUMBER" autocomplete="off" value="[{$dynvalue.kknumber}]" placeholder="[{oxmultilang ident="D3HEIDELPAY_PAYMENT_INPUT_NUMBER"}]" />
                    <p class="validation-error">
                        <span class="js-oxError_notEmpty">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_PAGE_EXCEPTION_INPUT_NOTALLFIELDS"}]</span>
                    </p>
                </li>
                <li>
                    <label for="ACCOUNT.HOLDER">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_INPUT_CARDHOLDER"}]</label>
                    <input type="text" size="20" class="js-oxValidate js-oxValidate_notEmpty" maxlength="64" name="ACCOUNT.HOLDER" value="[{if $dynvalue.kkname}][{$dynvalue.kkname}][{else}][{$oxcmp_user->oxuser__oxfname->value}] [{$oxcmp_user->oxuser__oxlname->value}][{/if}]" placeholder="[{oxmultilang ident="D3HEIDELPAY_PAYMENT_INPUT_CARDHOLDER"}]" />
                    <p class="validation-error">
                        <span class="js-oxError_notEmpty">[{oxmultilang ident="ERROR_MESSAGE_INPUT_NOTALLFIELDS"}]</span>
                    </p>
                    <div class="note">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_IF_DIFFERENT_FROM_BILLING_ADDRESS"}]</div>
                </li>
                <li>
                    <label>[{oxmultilang ident="D3HEIDELPAY_PAYMENT_INPUT_VALID_UNTIL"}]</label>
                    <div class="cardValidDateWrapper">
                        [{include file="formelement_selectlist_month_mobile.tpl"}]
                        <div class="card-valid-date-field card-valid-date-divider">/</div>
                        [{include file="formelement_selectlist_year_mobile.tpl"}]
                    </div>
                </li>
                <li>
                    <label for="ACCOUNT.VERIFICATION">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_INPUT_CARD_SECURITY_CODE"}]</label>
                    <input type="number" class="js-oxValidate js-oxValidate_notEmpty" size="64" maxlength="64" name="ACCOUNT.VERIFICATION" autocomplete="off" value="[{$dynvalue.kkpruef}]" placeholder="[{oxmultilang ident="D3HEIDELPAY_PAYMENT_INPUT_CARD_SECURITY_CODE"}]" />
                    <p class="validation-error">
                        <span class="js-oxError_notEmpty">[{oxmultilang ident="D3HEIDELPAY_PAYMENT_PAGE_EXCEPTION_INPUT_NOTALLFIELDS"}]</span>
                    </p>
                    <div class="note">[{*oxmultilang ident="D3HEIDELPAY_PAYMENT_INPUT_CARD_SECURITY_CODE"*}]</div>
                </li>

                <li>
                    <div class="note">
                        [{oxmultilang ident="D3PAYMENT_SECURITYCODEDESCRIPTION"}]
                        [{if $aCCTypes.AMEX && $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "CC"}]
                                [{oxmultilang ident="D3PAYMENT_SECURITYCODEDESCRIPTION_AMEX"}]
                        [{/if}]
                    </div>

                    <img src="[{$sImageUrl}]pruefziffer_visa.jpg" alt="visa">
                    [{if $aCCTypes.AMEX && $oHeidelpayViewConfig->getPaymentCode($payment->getId()) == "CC"}]
                        <img src="[{$sImageUrl}]pruefziffer_amex.jpg" alt="visa">
                    [{/if}]
                </li>

                [{if $paymentmethod->oxpayments__oxlongdesc->value}]
                    <li>
                        <div class="payment-desc">
                            [{$paymentmethod->oxpayments__oxlongdesc->getRawValue()}]
                        </div>
                    </li>
                [{/if}]
            </ul>
        </div>
    </div>
    [{*
    <div class="lineBox clear">
        <a href="[{oxgetseourl ident=$oViewConf->getSelfLink()|cat:"cl=order"}]"
           class="btn">[{oxmultilang ident="[{oxgetseourl ident=$oViewConf->getSelfLink()|cat:"cl=order"}]"}]</a>

        <button type="submit"
                name="userform"
                class="btn"
                id="paymentNextStepBottom">[{oxmultilang ident="D3HEIDELPAY_ORDER_PAGE_NEXTSTEP"}]</button>
    </div>
    *}]
    <ul class="form">
        <li><input type="submit" id="paymentNextStepBottom" name="userform" class="btn" value="[{oxmultilang ident="D3HEIDELPAY_ORDER_PAGE_NEXTSTEP"}]" /></li>
        [{*<li><input type="button" id="paymentBackStepBottom" class="btn previous" value="[{oxmultilang ident="PREVIOUS_STEP"}]" onclick="window.open('[{oxgetseourl ident=$oViewConf->getSelfLink()|cat:"cl=order"}]', '_self');" /></li>*}]
        <li><input type="button" id="paymentBackStepBottom" class="btn previous" value="[{oxmultilang ident="D3HEIDELPAY_ORDER_PAGE_BACKSTEPT"}]" onclick="window.open('[{oxgetseourl ident=$oViewConf->getSelfLink()|cat:"cl=order"}]', '_self');" /></li>
    </ul>
    </form>
</div>
[{*
    <div id="d3HeidelpayWait" class="popupBox corners FXgradGreyLight glowShadow">
        <table class="d3HeidelpayInfoTable" cellpadding="0" cellspacing="0">
            <tr>
                <td class="d3HeidelpayInfoCell">[{oxmultilang ident="D3HEIDELPAY_SENDING_FORMULAR"}]</td>
            </tr>
        </table>
    </div>
*}]

    [{oxscript add="$('#payment').find('.dropdown').oxDropDown();"}]

    [{insert name="oxid_tracker" title=$template_title}]
[{/capture}]

[{include file="layout/page.tpl"}]
