<?php

/**
 * Class d3_d3heidelpay_models_payment_postfinance
 */
class d3_d3heidelpay_models_payment_postfinance extends d3_d3heidelpay_models_payment_abstract
{
    protected $paymentBones = array(
        'PA' => array(),
        'RC' => array(),
        'RF' => array(),
    );
    /**
     * {@inheritdoc}
     */
    public function getPaymentMethod()
    {
        return 'postfinance';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentCode()
    {
        return 'OT';
    }

    /**
     * {@inheritdoc}
     */
    public function getPaymentChannel()
    {
        return oxRegistry::get('d3_cfg_mod')->get('d3heidelpay')->getValue('d3heidelpay_sChannel__postfinance');
    }

    /**
     * returns empty array
     *
     * @param d3_d3heidelpay_models_response_parser $oParser
     *
     * @return array
     */
    public function getDynamicValues(d3_d3heidelpay_models_response_parser $oParser)
    {
        return array();
    }

    /**
     * @return d3_d3heidelpay_models_redirect
     */
    public function getRedirect()
    {
        return oxNew('d3_d3heidelpay_models_redirect');
    }

    /**
     * @return string
     */
    public function getSyncMode()
    {
        return 'ASYNC';
    }
}
